/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.flight;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.SmoothDouble;
import net.minecraft.world.phys.Vec3;
import nl.enjarai.doabarrelroll.DoABarrelRoll;
import nl.enjarai.doabarrelroll.DoABarrelRollClient;
import nl.enjarai.doabarrelroll.ModKeybindings;
import nl.enjarai.doabarrelroll.api.event.RollContext;
import nl.enjarai.doabarrelroll.api.rotation.RotationInstant;
import nl.enjarai.doabarrelroll.config.ModConfig;
import nl.enjarai.doabarrelroll.config.Sensitivity;
import nl.enjarai.doabarrelroll.math.Expression;

public class RotationModifiers {
    public static RollContext.ConfiguresRotation buttonControls(double power) {
        return (rotationInstant, context) -> {
            double delta = power * context.getRenderDelta();
            int pitch = 0;
            int yaw = 0;
            int roll = 0;
            if (ModKeybindings.PITCH_UP.m_90857_()) {
                pitch = (int)((double)pitch - delta);
            }
            if (ModKeybindings.PITCH_DOWN.m_90857_()) {
                pitch = (int)((double)pitch + delta);
            }
            if (ModKeybindings.YAW_LEFT.m_90857_()) {
                yaw = (int)((double)yaw - delta);
            }
            if (ModKeybindings.YAW_RIGHT.m_90857_()) {
                yaw = (int)((double)yaw + delta);
            }
            if (ModKeybindings.ROLL_LEFT.m_90857_()) {
                roll = (int)((double)roll - delta);
            }
            if (ModKeybindings.ROLL_RIGHT.m_90857_()) {
                roll = (int)((double)roll + delta);
            }
            return rotationInstant.add(pitch, yaw, roll);
        };
    }

    public static RollContext.ConfiguresRotation smoothing(SmoothDouble pitchSmoother, SmoothDouble yawSmoother, SmoothDouble rollSmoother, Sensitivity smoothness) {
        return (rotationInstant, context) -> RotationInstant.of(smoothness.pitch == 0.0 ? rotationInstant.pitch() : pitchSmoother.m_14237_(rotationInstant.pitch(), 1.0 / smoothness.pitch * context.getRenderDelta()), smoothness.yaw == 0.0 ? rotationInstant.yaw() : yawSmoother.m_14237_(rotationInstant.yaw(), 1.0 / smoothness.yaw * context.getRenderDelta()), smoothness.roll == 0.0 ? rotationInstant.roll() : rollSmoother.m_14237_(rotationInstant.roll(), 1.0 / smoothness.roll * context.getRenderDelta()));
    }

    public static RotationInstant banking(RotationInstant rotationInstant, RollContext context) {
        double delta = context.getRenderDelta();
        RotationInstant currentRotation = context.getCurrentRotation();
        double currentRoll = currentRotation.roll() * (Math.PI / 180);
        Expression xExpression = ModConfig.INSTANCE.getBankingXFormula().getCompiledOrDefaulting(0.0);
        Expression yExpression = ModConfig.INSTANCE.getBankingYFormula().getCompiledOrDefaulting(0.0);
        Map<String, Double> vars = RotationModifiers.getVars(context);
        vars.put("banking_strength", ModConfig.INSTANCE.getBankingStrength());
        double dX = xExpression.eval(vars);
        double dY = yExpression.eval(vars);
        if (Double.isNaN(dX)) {
            dX = 0.0;
        }
        if (Double.isNaN(dY)) {
            dY = 0.0;
        }
        return rotationInstant.addAbsolute(dX * delta, dY * delta, currentRoll);
    }

    public static RotationInstant manageThrottle(RotationInstant rotationInstant, RollContext context) {
        double delta = context.getRenderDelta();
        DoABarrelRollClient.throttle = ModKeybindings.THRUST_FORWARD.m_90857_() ? (DoABarrelRollClient.throttle += 0.1 * delta) : (ModKeybindings.THRUST_BACKWARD.m_90857_() ? (DoABarrelRollClient.throttle -= 0.1 * delta) : (DoABarrelRollClient.throttle -= DoABarrelRollClient.throttle * 0.95 * delta));
        DoABarrelRollClient.throttle = Mth.m_14008_((double)DoABarrelRollClient.throttle, (double)0.0, (double)ModConfig.INSTANCE.getMaxThrust());
        return rotationInstant;
    }

    public static RollContext.ConfiguresRotation fixNaN(String name) {
        return (rotationInstant, context) -> {
            if (Double.isNaN(rotationInstant.pitch())) {
                rotationInstant = RotationInstant.of(0.0, rotationInstant.yaw(), rotationInstant.roll());
                DoABarrelRoll.LOGGER.warn("NaN found in pitch for " + name + ", setting to 0 as fallback");
            }
            if (Double.isNaN(rotationInstant.yaw())) {
                rotationInstant = RotationInstant.of(rotationInstant.pitch(), 0.0, rotationInstant.roll());
                DoABarrelRoll.LOGGER.warn("NaN found in yaw for " + name + ", setting to 0 as fallback");
            }
            if (Double.isNaN(rotationInstant.roll())) {
                rotationInstant = RotationInstant.of(rotationInstant.pitch(), rotationInstant.yaw(), 0.0);
                DoABarrelRoll.LOGGER.warn("NaN found in roll for " + name + ", setting to 0 as fallback");
            }
            return rotationInstant;
        };
    }

    public static RotationInstant applyControlSurfaceEfficacy(RotationInstant rotationInstant, RollContext context) {
        Expression elevatorExpression = ModConfig.INSTANCE.getElevatorEfficacyFormula().getCompiledOrDefaulting(1.0);
        Expression aileronExpression = ModConfig.INSTANCE.getAileronEfficacyFormula().getCompiledOrDefaulting(1.0);
        Expression rudderExpression = ModConfig.INSTANCE.getRudderEfficacyFormula().getCompiledOrDefaulting(1.0);
        Map<String, Double> vars = RotationModifiers.getVars(context);
        return rotationInstant.multiply(elevatorExpression.eval(vars), rudderExpression.eval(vars), aileronExpression.eval(vars));
    }

    private static Map<String, Double> getVars(RollContext context) {
        final LocalPlayer player = Minecraft.m_91087_().f_91074_;
        assert (player != null);
        final RotationInstant currentRotation = context.getCurrentRotation();
        final Vec3 rotationVector = player.m_20154_();
        return new HashMap<String, Double>(){
            {
                this.put("pitch", currentRotation.pitch());
                this.put("yaw", currentRotation.yaw());
                this.put("roll", currentRotation.roll());
                this.put("velocity_length", player.m_20184_().m_82553_());
                this.put("velocity_x", player.m_20184_().m_7096_());
                this.put("velocity_y", player.m_20184_().m_7098_());
                this.put("velocity_z", player.m_20184_().m_7094_());
                this.put("look_x", rotationVector.m_7096_());
                this.put("look_y", rotationVector.m_7098_());
                this.put("look_z", rotationVector.m_7094_());
            }
        };
    }
}

