/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.botania_overpowered.mixin.flower;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.yukkuric.botania_overpowered.BotaniaOPConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.common.block.flower.generating.EndoflameBlockEntity;

@Mixin(value={EndoflameBlockEntity.class})
public abstract class MixinEndoflame
extends GeneratingFlowerBlockEntity {
    @Shadow(remap=false)
    private int burnTime;
    @Shadow(remap=false)
    @Final
    private static int FUEL_CAP;
    private int overrideMaxMana = -1;

    @Shadow(remap=false)
    public abstract int getMaxMana();

    public MixinEndoflame(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    private int time2mana(int time) {
        return (int)Math.min(2.1474836E9f, (float)time * 3.0f / 2.0f);
    }

    private int mana2time(int mana) {
        return (int)Math.min(2.1474836E9f, (float)mana * 2.0f / 3.0f);
    }

    @Inject(method={"getMaxMana"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    public void replacedMaxMana(CallbackInfoReturnable<Integer> cir) {
        if (BotaniaOPConfig.extraCapacityForFuel() && this.overrideMaxMana > 0) {
            cir.setReturnValue((Object)this.overrideMaxMana);
        }
    }

    @Inject(method={"getBurnTime"}, at={@At(value="RETURN")}, remap=false)
    public void calcMaxMana(CallbackInfoReturnable<Integer> cir) {
        this.overrideMaxMana = Math.max(this.getMaxMana(), this.time2mana((Integer)cir.getReturnValue()));
    }

    @Inject(method={"tickFlower"}, at={@At(value="HEAD")}, remap=false)
    void manualBoostTicks(CallbackInfo ci) {
        if (!BotaniaOPConfig.instantBurnFuel()) {
            return;
        }
        if (this.burnTime > 0) {
            int maxManaFromTime = this.time2mana(this.burnTime);
            int maxManaToFill = this.getMaxMana() - this.getMana();
            if (maxManaToFill >= maxManaFromTime) {
                this.addMana(maxManaFromTime);
                this.burnTime = 0;
            } else {
                this.addMana(maxManaToFill);
                this.burnTime -= this.mana2time(maxManaToFill);
            }
        }
    }

    @WrapOperation(method={"tickFlower"}, at={@At(value="INVOKE", target="Ljava/lang/Math;min(II)I")}, remap=false)
    int noMore32000Limit(int a, int b, Operation<Integer> original) {
        if (a != FUEL_CAP || !BotaniaOPConfig.breaksMaxBurningTimeLimit()) {
            return (Integer)original.call(new Object[]{a, b});
        }
        return b;
    }
}

