/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.botania_overpowered.forge.mekanism;

import com.google.common.base.Suppliers;
import io.yukkuric.botania_overpowered.forge.BotaniaOPConfigForge;
import java.util.function.Supplier;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.common.util.StorageUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.api.mana.ManaItem;

public class MekasuitManaItem
implements ManaItem {
    final Supplier<IEnergyContainer> source = Suppliers.memoize(() -> StorageUtils.getEnergyContainer((ItemStack)target, (int)0));

    public MekasuitManaItem(ItemStack target) {
    }

    static int Joule2Mana(FloatingLong raw) {
        FloatingLong FE = raw.multiply(0.4);
        return FE.multiply(BotaniaOPConfigForge.MekasuitConversionRatio()).intValue();
    }

    static boolean isRatioValid() {
        return BotaniaOPConfigForge.MekasuitConversionRatio() > 0.0;
    }

    public int getMana() {
        return MekasuitManaItem.Joule2Mana(this.source.get().getEnergy());
    }

    public int getMaxMana() {
        return MekasuitManaItem.Joule2Mana(this.source.get().getMaxEnergy());
    }

    public void addMana(int i) {
        double ratio = BotaniaOPConfigForge.MekasuitConversionRatio();
        if (ratio <= 0.0) {
            return;
        }
        int finalMana = this.getMana() + i;
        finalMana = Math.max(finalMana, 0);
        FloatingLong fe = FloatingLong.create((double)((double)finalMana / ratio));
        this.source.get().setEnergy(fe.multiply(2.5));
    }

    public boolean canReceiveManaFromPool(BlockEntity blockEntity) {
        return MekasuitManaItem.isRatioValid();
    }

    public boolean canReceiveManaFromItem(ItemStack itemStack) {
        return false;
    }

    public boolean canExportManaToPool(BlockEntity blockEntity) {
        return MekasuitManaItem.isRatioValid();
    }

    public boolean canExportManaToItem(ItemStack itemStack) {
        return MekasuitManaItem.isRatioValid();
    }

    public boolean isNoExport() {
        return false;
    }
}

