/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;
import twilightforest.init.TFBlocks;
import twilightforest.util.FeaturePlacers;
import twilightforest.util.FeatureUtil;
import twilightforest.world.components.feature.config.TFTreeFeatureConfig;
import twilightforest.world.components.feature.trees.TFTreeFeature;

public class MiningTreeFeature
extends TFTreeFeature<TFTreeFeatureConfig> {
    public MiningTreeFeature(Codec<TFTreeFeatureConfig> config) {
        super(config);
    }

    @Override
    protected boolean generate(WorldGenLevel world, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, BiConsumer<BlockPos, BlockState> decorationPlacer, TFTreeFeatureConfig config) {
        if (world.m_151562_(pos.m_123342_() + 12)) {
            return false;
        }
        BlockState state = world.m_8055_(pos.m_7495_());
        if (!state.m_60734_().canSustainPlant(state, (BlockGetter)world, pos.m_7495_(), Direction.UP, (IPlantable)TFBlocks.MINING_SAPLING.get())) {
            return false;
        }
        for (int dy = 0; dy <= 9; ++dy) {
            FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, random, pos.m_6630_(dy), config.trunkProvider);
        }
        MiningTreeFeature.putBranchWithLeaves((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos.m_7918_(0, 9, 1), true, config);
        MiningTreeFeature.putBranchWithLeaves((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos.m_7918_(0, 9, 2), false, config);
        MiningTreeFeature.putBranchWithLeaves((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos.m_7918_(0, 8, 3), false, config);
        MiningTreeFeature.putBranchWithLeaves((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos.m_7918_(0, 7, 4), false, config);
        MiningTreeFeature.putBranchWithLeaves((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos.m_7918_(0, 6, 5), false, config);
        MiningTreeFeature.putBranchWithLeaves((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos.m_7918_(0, 9, -1), true, config);
        MiningTreeFeature.putBranchWithLeaves((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos.m_7918_(0, 9, -2), false, config);
        MiningTreeFeature.putBranchWithLeaves((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos.m_7918_(0, 8, -3), false, config);
        MiningTreeFeature.putBranchWithLeaves((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos.m_7918_(0, 7, -4), false, config);
        MiningTreeFeature.putBranchWithLeaves((LevelAccessor)world, trunkPlacer, leavesPlacer, random, pos.m_7918_(0, 6, -5), false, config);
        world.m_7731_(pos.m_7494_(), (BlockState)((Block)TFBlocks.MINING_LOG_CORE.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y), 3);
        world.m_186460_(pos.m_7494_(), (Block)TFBlocks.MINING_LOG_CORE.get(), 20);
        if (FeatureUtil.hasAirAround((LevelAccessor)world, pos.m_7495_())) {
            FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, random, pos.m_7495_(), config.trunkProvider);
        } else {
            FeaturePlacers.placeIfValidRootPos((LevelSimulatedReader)world, decorationPlacer, random, pos.m_7495_(), config.rootsProvider);
        }
        int numRoots = 3 + random.m_188503_(2);
        float offset = random.m_188501_();
        for (int b = 0; b < numRoots; ++b) {
            FeaturePlacers.buildRoot((LevelAccessor)world, decorationPlacer, random, pos, offset, b, config.rootsProvider);
        }
        return true;
    }

    protected static void putBranchWithLeaves(LevelAccessor world, BiConsumer<BlockPos, BlockState> trunkPlacer, BiConsumer<BlockPos, BlockState> leavesPlacer, RandomSource rand, BlockPos pos, boolean bushy, TFTreeFeatureConfig config) {
        FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, rand, pos, config.branchProvider);
        for (int lx = -1; lx <= 1; ++lx) {
            for (int ly = -1; ly <= 1; ++ly) {
                for (int lz = -1; lz <= 1; ++lz) {
                    if (!bushy && Math.abs(ly) > 0 && Math.abs(lx) > 0) continue;
                    FeaturePlacers.placeProvidedBlock((LevelSimulatedReader)world, leavesPlacer, FeaturePlacers.VALID_TREE_POS, pos.m_7918_(lx, ly, lz), config.leavesProvider, rand);
                }
            }
        }
    }
}

