/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.tree.decorator;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.api.condition.AbstractCondition;
import net.zepalesque.redux.util.codec.ReduxCodecs;
import net.zepalesque.redux.world.tree.decorator.ReduxTreeDecorators;

public class EnchantedVineDecorator
extends TreeDecorator {
    public static final MapCodec<EnchantedVineDecorator> BASE_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(config -> Float.valueOf(config.probability)), (App)BlockStateProvider.f_68747_.fieldOf("plant_body_provider").forGetter(config -> config.bodyBlock), (App)BlockStateProvider.f_68747_.fieldOf("plant_head_provider").forGetter(config -> config.headBlock), (App)IntProvider.m_146545_((int)1, (int)128).fieldOf("length").forGetter(config -> config.length), (App)AbstractCondition.CODEC.optionalFieldOf("condition").forGetter(config -> config.condition)).apply((Applicative)builder, EnchantedVineDecorator::new));
    public static final MapCodec<EnchantedVineDecorator> COMPAT_CODEC = RecordCodecBuilder.mapCodec(vines -> vines.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability_min").forGetter(config -> Float.valueOf(0.0f)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability_max").forGetter(config -> Float.valueOf(0.0f)), (App)BlockStateProvider.f_68747_.fieldOf("plant_body_provider").forGetter(config -> config.bodyBlock), (App)BlockStateProvider.f_68747_.fieldOf("plant_head_provider").forGetter(config -> config.headBlock), (App)IntProvider.m_146545_((int)1, (int)128).fieldOf("length_min").forGetter(config -> ConstantInt.f_146476_), (App)IntProvider.m_146545_((int)1, (int)128).fieldOf("length_max").forGetter(config -> ConstantInt.f_146476_), (App)AbstractCondition.CODEC.optionalFieldOf("condition").forGetter(config -> config.condition)).apply((Applicative)vines, (unused1, unused2, body, head, unused3, unused4, condition) -> EnchantedVineDecorator.forBackwardsCompat(body, head, condition)));
    public static final Codec<EnchantedVineDecorator> CODEC = ReduxCodecs.mapAlternative(BASE_CODEC, COMPAT_CODEC).codec();
    private final float probability;
    private final BlockStateProvider bodyBlock;
    private final BlockStateProvider headBlock;
    private final IntProvider length;
    private final Optional<AbstractCondition<?>> condition;

    static EnchantedVineDecorator forBackwardsCompat(BlockStateProvider body, BlockStateProvider head, Optional<AbstractCondition<?>> condition) {
        return new EnchantedVineDecorator(0.25f, body, head, (IntProvider)UniformInt.m_146622_((int)1, (int)5), condition);
    }

    public EnchantedVineDecorator(float vineProbability, BlockStateProvider bodyBlock, BlockStateProvider headBlock, IntProvider vineLength, Optional<AbstractCondition<?>> condition) {
        this.probability = vineProbability;
        this.bodyBlock = bodyBlock;
        this.headBlock = headBlock;
        this.length = vineLength;
        this.condition = condition;
    }

    public void m_214187_(TreeDecorator.Context pContext) {
        HashBasedTable xzyLowestMap = HashBasedTable.create();
        ObjectArrayList l = pContext.m_226069_().clone();
        Collections.reverse(l);
        for (BlockPos leafPos : l) {
            int x = leafPos.m_123341_();
            int y = leafPos.m_123342_();
            int z = leafPos.m_123343_();
            try {
                if (!xzyLowestMap.contains((Object)x, (Object)z)) {
                    xzyLowestMap.put((Object)x, (Object)z, (Object)y);
                    continue;
                }
                if (y >= (Integer)xzyLowestMap.get((Object)x, (Object)z)) continue;
                xzyLowestMap.put((Object)x, (Object)z, (Object)y);
            }
            catch (NullPointerException exception) {
                Redux.LOGGER.error("Caught error when trying to add leaf to table!", (Throwable)exception);
            }
        }
        RandomSource randomsource = pContext.m_226067_();
        for (Table.Cell leafPos : xzyLowestMap.cellSet()) {
            BlockPos blockpos;
            BlockPos pos = new BlockPos(((Integer)leafPos.getRowKey()).intValue(), ((Integer)leafPos.getValue()).intValue(), ((Integer)leafPos.getColumnKey()).intValue());
            int length = this.length.m_214085_(randomsource);
            if (!(randomsource.m_188501_() < this.probability) || !pContext.m_226059_(blockpos = pos.m_7495_())) continue;
            this.addVine(blockpos, pContext, length);
        }
    }

    private void addVine(BlockPos pPos, TreeDecorator.Context pContext, int length) {
        for (int i = 1; i <= length; ++i) {
            boolean maxLength;
            BlockPos placement = pPos.m_7918_(0, 1 - i, 0);
            boolean notAirBelow = !pContext.m_226059_(placement.m_7495_());
            boolean bl = maxLength = i >= length;
            if (notAirBelow || maxLength) {
                pContext.m_226061_(placement, this.headBlock.m_213972_(pContext.m_226067_(), pPos));
                break;
            }
            pContext.m_226061_(placement, this.bodyBlock.m_213972_(pContext.m_226067_(), pPos));
        }
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)ReduxTreeDecorators.ENCHANTED_VINES.get();
    }

    public static <U> U unwrap(Either<? extends U, ? extends U> either) {
        return (U)either.map(Function.identity(), Function.identity());
    }
}

