/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.world.density.PerlinNoiseFunction;

public class CloudbedFeature
extends Feature<Config> {
    public CloudbedFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> context) {
        Config config = (Config)context.m_159778_();
        if (Redux.ancientAetherCompat() && !config.overrideCompat().orElse(false).booleanValue()) {
            return false;
        }
        WorldGenLevel level = context.m_159774_();
        DensityFunction cloudNoise = config.cloudNoise();
        DensityFunction yOffsetNoise = config.yOffset();
        PerlinNoiseFunction.PerlinNoiseVisitor visitor = PerlinNoiseFunction.createOrGetVisitor(level.m_7328_());
        cloudNoise.m_207456_((DensityFunction.Visitor)visitor);
        yOffsetNoise.m_207456_((DensityFunction.Visitor)visitor);
        int chunkX = context.m_159777_().m_123341_() - context.m_159777_().m_123341_() % 16;
        int chunkZ = context.m_159777_().m_123343_() - context.m_159777_().m_123343_() % 16;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int xCoord = chunkX + x;
                int zCoord = chunkZ + z;
                double cloudCalc = cloudNoise.m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(xCoord, config.yLevel(), zCoord));
                double offsetCalc = yOffsetNoise.m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(xCoord, config.yLevel(), zCoord));
                float realOffset = CloudbedFeature.cosineInterp((float)Mth.m_14112_((double)offsetCalc, (double)-0.5, (double)0.5), 0.0f, (float)config.maxYOffset());
                if (!(cloudCalc >= 0.0)) continue;
                float realCloud = CloudbedFeature.cosineInterp((float)Mth.m_14008_((double)cloudCalc, (double)0.0, (double)1.0), 0.0f, 1.0f);
                float blocksUp = Mth.m_14179_((float)realCloud, (float)0.0f, (float)((float)config.cloudRadius())) + realOffset;
                float blocksDown = Mth.m_14179_((float)realCloud, (float)0.0f, (float)((float)config.cloudRadius() - 1.0f)) - realOffset;
                for (int i = Mth.m_14143_((float)(-blocksDown)); i <= Mth.m_14143_((float)blocksUp); ++i) {
                    int y = Mth.m_14045_((int)(config.yLevel() + i), (int)context.m_159774_().m_141937_(), (int)context.m_159774_().m_151558_());
                    BlockPos pos = new BlockPos(xCoord, y, zCoord);
                    if (!config.predicate().test((Object)context.m_159774_(), (Object)pos)) continue;
                    this.m_5974_((LevelWriter)context.m_159774_(), pos, config.block().m_213972_(context.m_225041_(), pos));
                }
            }
        }
        return false;
    }

    private static float cosineInterp(float progress, float start, float end) {
        return (-Mth.m_14089_((float)((float)(Math.PI * (double)progress))) + 1.0f) * 0.5f * (end - start) + start;
    }

    public record Config(BlockStateProvider block, BlockPredicate predicate, int yLevel, DensityFunction cloudNoise, double cloudRadius, DensityFunction yOffset, double maxYOffset, Optional<Boolean> overrideCompat) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockStateProvider.f_68747_.fieldOf("block").forGetter(Config::block), (App)BlockPredicate.f_190392_.fieldOf("predicate").forGetter(Config::predicate), (App)Codec.INT.fieldOf("y_level").forGetter(Config::yLevel), (App)DensityFunction.f_208218_.fieldOf("cloud_noise").forGetter(Config::cloudNoise), (App)Codec.DOUBLE.fieldOf("cloud_radius").forGetter(Config::cloudRadius), (App)DensityFunction.f_208218_.fieldOf("offset_noise").forGetter(Config::yOffset), (App)Codec.DOUBLE.fieldOf("offset_max").forGetter(Config::maxYOffset), (App)Codec.BOOL.optionalFieldOf("override_compat_disable").forGetter(Config::overrideCompat)).apply((Applicative)builder, Config::new));
    }
}

