/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.biome.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.zepalesque.redux.api.predicate.MusicPredicate;

public record MusicModifier(HolderSet<Biome> biomes, MusicOperator newMusic, Optional<MusicPredicate> predicate) implements BiomeModifier
{
    public static final Codec<MusicModifier> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(MusicModifier::biomes), (App)MusicOperator.CODEC.fieldOf("new_track").forGetter(MusicModifier::newMusic), (App)MusicPredicate.CODEC.optionalFieldOf("predicate").forGetter(MusicModifier::predicate)).apply((Applicative)builder, MusicModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.AFTER_EVERYTHING && this.biomes.m_203333_(biome) && builder.getSpecialEffects().getBackgroundMusic().isPresent()) {
            Music transformed;
            Music music = (Music)builder.getSpecialEffects().getBackgroundMusic().get();
            if ((this.predicate.isEmpty() || this.predicate.get().test(music)) && (transformed = this.newMusic.apply(music)) != music) {
                builder.getSpecialEffects().m_48021_(transformed);
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return CODEC;
    }

    public record MusicOperator(Optional<Holder<SoundEvent>> sound, Optional<Integer> minDelay, Optional<Integer> maxDelay, Optional<Boolean> replaceCurrent) implements UnaryOperator<Music>
    {
        public static final Codec<MusicOperator> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)SoundEvent.f_263130_.optionalFieldOf("sound").forGetter(MusicOperator::sound), (App)Codec.INT.optionalFieldOf("min_delay").forGetter(MusicOperator::minDelay), (App)Codec.INT.optionalFieldOf("max_delay").forGetter(MusicOperator::maxDelay), (App)Codec.BOOL.optionalFieldOf("replace_current").forGetter(MusicOperator::replaceCurrent)).apply((Applicative)builder, MusicOperator::new));

        @Override
        public Music apply(Music music) {
            if (this.sound.isEmpty() && this.minDelay.isEmpty() && this.maxDelay.isEmpty() && this.replaceCurrent.isEmpty()) {
                return music;
            }
            Holder<SoundEvent> soundEvent = music.m_263193_();
            int minimum = music.m_11636_();
            int maximum = music.m_11639_();
            boolean replace = music.m_11642_();
            if (this.sound.isPresent()) {
                soundEvent = this.sound.get();
            }
            if (this.minDelay.isPresent()) {
                minimum = this.minDelay.get();
            }
            if (this.maxDelay.isPresent()) {
                maximum = this.maxDelay.get();
            }
            if (this.replaceCurrent.isPresent()) {
                replace = this.replaceCurrent.get();
            }
            return new Music(soundEvent, minimum, maximum, replace);
        }
    }
}

