/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.recipe;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.zepalesque.redux.api.ItemStackConstructor;
import net.zepalesque.redux.item.util.CustomStackingBehavior;
import net.zepalesque.redux.recipe.StackingRecipe;

public abstract class AbstractStackingRecipe
implements StackingRecipe {
    protected final RecipeType<?> type;
    protected final ResourceLocation id;
    protected final Ingredient ingredient;
    protected final ItemStackConstructor result;
    protected final Optional<CompoundTag> additional;
    protected final Optional<SoundEvent> sound;

    public AbstractStackingRecipe(RecipeType<?> type, ResourceLocation id, Ingredient ingredient, ItemStackConstructor result, Optional<CompoundTag> additional, Optional<SoundEvent> sound) {
        this.type = type;
        this.id = id;
        this.ingredient = ingredient;
        this.result = result;
        this.additional = additional;
        this.sound = sound;
    }

    public boolean matches(Level level, ItemStack item) {
        return this.getIngredient().test(item);
    }

    @Override
    @Nullable
    public ItemStack getResultStack(ItemStack originalStack) {
        if (!this.getIngredient().test(originalStack)) {
            return null;
        }
        ItemStack resultStack = this.getResult().createStack();
        resultStack.m_41751_(originalStack.m_41783_() != null ? originalStack.m_41783_().m_6426_() : null);
        resultStack.m_41764_(originalStack.m_41613_());
        Item item = resultStack.m_41720_();
        if (item instanceof CustomStackingBehavior) {
            CustomStackingBehavior custom = (CustomStackingBehavior)item;
            resultStack = custom.transformStack(this.ingredient, resultStack, this.type, this.additional);
        }
        return resultStack;
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public ItemStackConstructor getResult() {
        return this.result;
    }

    @Override
    public Optional<CompoundTag> getAdditionalData() {
        return this.additional;
    }

    @Override
    public Optional<SoundEvent> getSound() {
        return this.sound;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }
}

