/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.mixin.common.entity;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.zepalesque.redux.capability.arrow.SubzeroArrow;
import net.zepalesque.redux.client.particle.ReduxParticleTypes;
import net.zepalesque.redux.network.ReduxPacketHandler;
import net.zepalesque.redux.network.packet.SubzeroArrowPacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrow.class})
public class ArrowMixin {
    @Shadow
    protected boolean f_36703_;

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        AbstractArrow arrow = (AbstractArrow)this;
        SubzeroArrow.get(arrow).ifPresent(subzeroArrow -> {
            if (subzeroArrow.isSubzeroArrow()) {
                subzeroArrow.tick();
                if (!arrow.m_9236_().f_46443_) {
                    ReduxPacketHandler.sendToAll(new SubzeroArrowPacket(arrow.m_19879_(), true));
                }
            }
        });
    }

    @WrapWithCondition(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V", ordinal=0)})
    private boolean replaceParticle(Level instance, ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        return this.particleCheck(instance, particleData, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Unique
    private boolean particleCheck(Level instance, ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        AbstractArrow arrow = (AbstractArrow)this;
        LazyOptional<SubzeroArrow> subz = SubzeroArrow.get(arrow);
        if (subz.isPresent() && ((SubzeroArrow)subz.orElseThrow(() -> new IllegalStateException("Subzero arrow capability was not present right after checking to ensure it's present??? This should not be possible!"))).isSubzeroArrow()) {
            instance.m_7106_((ParticleOptions)ReduxParticleTypes.FROST.get(), x, y, z, xSpeed, ySpeed, zSpeed);
            return false;
        }
        return true;
    }
}

