/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.event.listener;

import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.nitrogen.capability.INBTSynchable;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import net.zepalesque.redux.capability.ReduxCapabilities;
import net.zepalesque.redux.capability.player.ReduxPlayer;
import net.zepalesque.redux.data.resource.ReduxDamageTypes;
import net.zepalesque.redux.effect.ReduxEffects;
import net.zepalesque.redux.entity.projectile.Ember;
import net.zepalesque.redux.item.ReduxItems;
import net.zepalesque.redux.util.math.MathUtil;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;

@Mod.EventBusSubscriber(modid="aether_redux")
public class EquipmentListener {
    @SubscribeEvent
    public static void increaseXP(LivingExperienceDropEvent event) {
        RegistryObject<Item> ring = ReduxItems.RING_OF_WISDOM;
        if (event.getAttackingPlayer() != null && EquipmentUtil.hasCurio((LivingEntity)event.getAttackingPlayer(), (Item)((Item)ring.get()))) {
            float multiplier = 1.0f;
            List ringList = EquipmentUtil.getCurios((LivingEntity)event.getAttackingPlayer(), (Item)((Item)ring.get()));
            for (SlotResult ignored : ringList) {
                multiplier *= 1.2f + event.getAttackingPlayer().m_217043_().m_188501_() * 0.1f;
            }
            if (multiplier != 1.0f) {
                int xp = Mth.m_14143_((float)((float)event.getDroppedExperience() * multiplier));
                event.setDroppedExperience(xp);
            }
        }
    }

    @SubscribeEvent
    public static void joinAndSetDoubleJumps(EntityJoinLevelEvent event) {
        ServerPlayer player;
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer && !(player = (ServerPlayer)entity).m_9236_().m_5776_()) {
            ReduxPlayer.get((Player)player).ifPresent(reduxPlayer -> reduxPlayer.setSynched(INBTSynchable.Direction.CLIENT, "setMaxAirJumps", EquipmentUtil.hasCurio((LivingEntity)player, (Item)((Item)ReduxItems.AIRBOUND_CAPE.get())) ? 1 : 0));
        }
    }

    @SubscribeEvent
    public static void removeInebriation(MobEffectEvent.Added event) {
        if (!event.getEntity().m_9236_().m_5776_()) {
            EquipmentUtil.findFirstCurio((LivingEntity)event.getEntity(), (Item)((Item)ReduxItems.FEATHER_OF_WARDING.get())).ifPresent(slotResult -> {
                if (event.getEffectInstance().m_19544_() == AetherEffects.INEBRIATION.get()) {
                    slotResult.stack().m_41622_(1, slotResult.slotContext().entity(), livingEntity -> CuriosApi.broadcastCurioBreakEvent((SlotContext)slotResult.slotContext()));
                    event.getEntity().m_21195_(event.getEffectInstance().m_19544_());
                }
            });
        }
    }

    @SubscribeEvent
    public static void hurt(LivingHurtEvent event) {
        Entity p;
        LivingEntity target = event.getEntity();
        if (!target.m_9236_().m_5776_() && EquipmentUtil.hasCurio((LivingEntity)target, (Item)((Item)ReduxItems.SHROOM_RING.get())) && target.m_21223_() / target.m_21233_() <= 0.6666667f) {
            if (target.m_21023_((MobEffect)ReduxEffects.ADRENALINE_RUSH.get()) && !target.m_21023_((MobEffect)ReduxEffects.ADRENAL_FATIGUE.get())) {
                int curr;
                MobEffectInstance i;
                delta = Mth.m_144920_((float)(1.0f - target.m_21223_() / target.m_21233_() * 1.5f), (float)0.25f, (float)0.5f);
                if (target.m_9236_().m_213780_().m_188501_() <= delta && (i = target.m_21124_((MobEffect)ReduxEffects.ADRENALINE_RUSH.get())) != null && (curr = i.m_19564_()) < 2) {
                    MobEffectInstance instance = new MobEffectInstance(i.m_19544_(), i.m_19557_(), i.m_19564_() + 1, i.m_19571_(), i.m_19572_(), i.m_19575_());
                    target.m_21195_((MobEffect)ReduxEffects.ADRENALINE_RUSH.get());
                    target.m_7292_(instance);
                }
            } else {
                delta = Mth.m_144920_((float)(1.0f - target.m_21223_() / target.m_21233_() * 1.5f), (float)0.5f, (float)0.75f);
                if (target.m_9236_().m_213780_().m_188501_() <= delta && !target.m_21023_((MobEffect)ReduxEffects.ADRENAL_FATIGUE.get()) && (target instanceof Player && ReduxPlayer.get((Player)(p = (Player)target)).isPresent() && ((ReduxPlayer)ReduxPlayer.get((Player)p).orElseThrow(ReduxCapabilities::error)).getAdrenalineModule().cooledDown() || !(target instanceof Player))) {
                    target.m_7292_(new MobEffectInstance((MobEffect)ReduxEffects.ADRENALINE_RUSH.get(), 600, 0, false, false, true));
                }
            }
        }
        if (target != null && (p = event.getSource().m_7640_()) instanceof Player) {
            Player player = (Player)p;
            if (!event.getSource().m_276093_(ReduxDamageTypes.EMBER) && (double)event.getAmount() > 1.0 && EquipmentUtil.hasCurio((LivingEntity)player, (Item)((Item)ReduxItems.SENTRY_RING.get()))) {
                int ringcount = EquipmentUtil.getCurios((LivingEntity)player, (Item)((Item)ReduxItems.SENTRY_RING.get())).size();
                RandomSource source = target.m_9236_().m_213780_();
                int embers = (double)event.getAmount() < 1.5 || player.m_21205_().m_41619_() ? 0 : Mth.m_14165_((double)(((double)event.getAmount() * 0.5 + 1.0) * (ringcount == 2 ? 1.5 : 1.0))) - source.m_188503_(1);
                for (int i = 1; i <= embers; ++i) {
                    float rotation = Mth.m_14098_((int)source.m_188503_(360));
                    Ember ember = new Ember(target.m_9236_(), player, (Entity)target);
                    ember.m_6034_(target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f) + (double)(source.m_188501_() * 2.0f - 1.0f), target.m_20189_());
                    ember.m_37251_((Entity)target, -45.0f + 90.0f * source.m_188501_(), rotation, 0.0f, 0.5f, 1.0f);
                    if (player.m_9236_().m_5776_()) continue;
                    player.m_9236_().m_7967_((Entity)ember);
                }
            }
        }
    }

    @SubscribeEvent
    public static void tickPlayer(LivingEvent.LivingTickEvent event) {
        int i;
        LivingEntity entity = event.getEntity();
        if (EquipmentUtil.hasCurio((LivingEntity)entity, (Item)((Item)ReduxItems.GRAND_VICTORY_MEDAL.get())) && (i = MathUtil.clampedLerpInt(entity.m_21223_() / entity.m_21233_(), 20, 200)) > 0 && entity.f_19797_ % i == 0 && entity.m_9236_().m_213780_().m_188499_()) {
            entity.m_5634_(1.0f);
        }
    }
}

