/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.entity.monster;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.entity.ai.goal.ContinuousMeleeAttackGoal;
import com.aetherteam.aether.entity.ai.goal.FallingRandomStrollGoal;
import com.aetherteam.aether.mixin.mixins.common.accessor.EntityAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.zepalesque.redux.client.audio.ReduxSoundEvents;
import net.zepalesque.redux.client.particle.ReduxParticleTypes;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Blightbunny
extends Monster
implements GeoEntity {
    @OnlyIn(value=Dist.CLIENT)
    public State anim;
    private static final EntityDataAccessor<Integer> DATA_PUFFINESS_ID = SynchedEntityData.m_135353_(Blightbunny.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_FAST_FALLING_ID = SynchedEntityData.m_135353_(Blightbunny.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int MAXIMUM_PUFFS = 11;
    private int puffSubtract;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public int getPuffSubtract() {
        return this.puffSubtract;
    }

    public Blightbunny(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new BlightbunnyMoveControl(this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new ContinuousMeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new FallingRandomStrollGoal((PathfinderMob)this, 1.0, 80));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Blightbunny.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22277_, 16.0);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ReduxSoundEvents.BLIGHTBUNNY_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ReduxSoundEvents.BLIGHTBUNNY_DEATH.get();
    }

    public static boolean checkBunnySpawnRules(EntityType<? extends Blightbunny> bnuuy, ServerLevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return Mob.m_217057_(bnuuy, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random) && Blightbunny.m_219009_(level, pos, random) && !level.m_8055_(pos.m_7495_()).m_204336_(AetherTags.Blocks.COCKATRICE_SPAWNABLE_BLACKLIST) && level.m_46791_() != Difficulty.PEACEFUL && (reason != MobSpawnType.NATURAL || random.m_188503_(3) == 0);
    }

    public static boolean m_219009_(ServerLevelAccessor level, BlockPos pos, RandomSource random) {
        if (level.m_45517_(LightLayer.SKY, pos) > random.m_188503_(32)) {
            return false;
        }
        DimensionType dimensiontype = level.m_6042_();
        int i = dimensiontype.m_223570_();
        if (i < 15 && level.m_45517_(LightLayer.BLOCK, pos) > i) {
            return false;
        }
        return level.m_46803_(pos) <= dimensiontype.m_223569_().m_214085_(random);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_183634_();
        if (!this.isFastFalling()) {
            this.handleFallSpeed();
        } else if (this.m_20096_()) {
            this.setFastFalling(false);
        }
        this.setPuffiness(this.getPuffiness() - this.puffSubtract);
        if (this.getPuffiness() > 0) {
            this.puffSubtract = 1;
        } else {
            this.puffSubtract = 0;
            this.setPuffiness(0);
        }
    }

    protected void midairJump() {
        if (this.m_5448_() == null) {
            Vec3 motion = this.m_20184_();
            if (motion.m_7098_() < 0.0) {
                this.puff();
                this.m_9236_().m_7605_((Entity)this, (byte)70);
            }
            this.m_20256_(new Vec3(motion.m_7096_(), 0.25, motion.m_7094_()));
        }
    }

    public void puff() {
        if (this.m_9236_() instanceof ServerLevel) {
            this.setPuffiness(11);
        }
    }

    private void handleFallSpeed() {
        AttributeInstance gravity = this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        if (gravity != null) {
            double fallSpeed = Math.max(gravity.m_22135_() * -1.25, -0.1);
            if (this.m_20184_().m_7098_() < fallSpeed) {
                this.m_20334_(this.m_20184_().m_7096_(), fallSpeed, this.m_20184_().m_7094_());
            }
        }
    }

    public void m_7822_(byte id) {
        if (id == 70) {
            this.spawnExplosionParticle();
        } else {
            super.m_7822_(id);
        }
    }

    private void spawnExplosionParticle() {
        for (int i = 0; i < 10; ++i) {
            Blightbunny.spawnMovementExplosionParticles((Entity)this);
        }
    }

    public static void spawnMovementExplosionParticles(Entity entity) {
        RandomSource random = ((EntityAccessor)entity).aether$getRandom();
        double d0 = random.m_188583_() * 0.02;
        double d1 = random.m_188583_() * 0.02;
        double d2 = random.m_188583_() * 0.02;
        double d3 = 10.0;
        double x = entity.m_20185_() + (double)random.m_188501_() * (double)entity.m_20205_() * 2.0 - (double)entity.m_20205_() - d0 * d3;
        double y = entity.m_20186_() + (double)random.m_188501_() * (double)entity.m_20206_() - d1 * d3;
        double z = entity.m_20189_() + (double)random.m_188501_() * (double)entity.m_20205_() * 2.0 - (double)entity.m_20205_() - d2 * d3;
        entity.m_9236_().m_7106_((ParticleOptions)ReduxParticleTypes.SHINY_CLOUD, x, y, z, d0, d1, d2);
    }

    public int getPuffiness() {
        return (Integer)this.f_19804_.m_135370_(DATA_PUFFINESS_ID);
    }

    public void setPuffiness(int puffiness) {
        this.f_19804_.m_135381_(DATA_PUFFINESS_ID, (Object)puffiness);
    }

    public void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_PUFFINESS_ID, (Object)0);
        this.m_20088_().m_135372_(DATA_FAST_FALLING_ID, (Object)false);
    }

    public boolean isFastFalling() {
        return (Boolean)this.f_19804_.m_135370_(DATA_FAST_FALLING_ID);
    }

    public void setFastFalling(boolean fastFalling) {
        this.f_19804_.m_135381_(DATA_FAST_FALLING_ID, (Object)fastFalling);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle_anims", 3, this::predicate)});
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "complex_anims", 3, this::complexAnims)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> state) {
        if (state.isMoving()) {
            state.getController().setAnimation(RawAnimation.begin().then("animations.blightbunny.walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        state.getController().setAnimation(RawAnimation.begin().then("animations.blightbunny.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState complexAnims(AnimationState<T> state) {
        State current = this.anim;
        if (current == State.ATTACKING) {
            state.getController().setAnimation(RawAnimation.begin().then("animations.blightbunny.attack", Animation.LoopType.PLAY_ONCE));
            this.anim = State.NONE;
        } else if (current == State.HURT) {
            state.getController().setAnimation(RawAnimation.begin().then("animations.blightbunny.hurt", Animation.LoopType.PLAY_ONCE));
            this.anim = State.NONE;
        } else if (current == State.JUMPING) {
            state.getController().setAnimation(RawAnimation.begin().then("animations.blightbunny.jump", Animation.LoopType.PLAY_ONCE));
            this.anim = State.NONE;
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static class BlightbunnyMoveControl
    extends MoveControl {
        private final Blightbunny aerbunny;

        public BlightbunnyMoveControl(Blightbunny aerbunny) {
            super((Mob)aerbunny);
            this.aerbunny = aerbunny;
        }

        public void m_8126_() {
            super.m_8126_();
            if (this.aerbunny.f_20902_ != 0.0f) {
                if (this.aerbunny.m_20096_()) {
                    this.aerbunny.m_21569_().m_24901_();
                } else {
                    int x = Mth.m_14107_((double)this.aerbunny.m_20185_());
                    int y = Mth.m_14107_((double)this.aerbunny.m_20191_().f_82289_);
                    int z = Mth.m_14107_((double)this.aerbunny.m_20189_());
                    if (this.aerbunny.m_5448_() == null && this.checkForSurfaces(this.aerbunny.m_9236_(), x, y, z) && !this.aerbunny.f_19862_) {
                        this.aerbunny.midairJump();
                    }
                }
            }
        }

        private boolean checkForSurfaces(Level level, int x, int y, int z) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
            if (level.m_8055_((BlockPos)pos.m_142448_(y - 1)).m_60795_()) {
                return false;
            }
            return level.m_8055_((BlockPos)pos.m_142448_(y + 2)).m_60795_() && level.m_8055_((BlockPos)pos.m_142448_(y + 1)).m_60795_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static enum State {
        ATTACKING,
        HURT,
        JUMPING,
        NONE;

    }
}

