/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;

public class RangedStrafeAttackGoal<T extends Mob>
extends Goal {
    protected final T mob;
    protected final double speedModifier;
    protected int attackIntervalMin;
    protected final float attackRadius;
    protected final float attackRadiusSqr;
    protected int attackTime = -1;
    protected LivingEntity target;
    protected int seeTime;
    protected boolean strafingClockwise;
    protected boolean strafingBackwards;
    protected int strafingTime = -1;
    protected final int attackIntervalMax;

    public RangedStrafeAttackGoal(T pMob, double pSpeedModifier, int pAttackIntervalMin, int pAttackIntervalMax, float pAttackRadius) {
        this.mob = pMob;
        this.speedModifier = pSpeedModifier;
        this.attackIntervalMin = pAttackIntervalMin;
        this.attackIntervalMax = pAttackIntervalMax;
        this.attackRadius = pAttackRadius;
        this.attackRadiusSqr = pAttackRadius * pAttackRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public RangedStrafeAttackGoal(T pRangedAttackMob, double pSpeedModifier, int pAttackInterval, float pAttackRadius) {
        this(pRangedAttackMob, pSpeedModifier, pAttackInterval, pAttackInterval, pAttackRadius);
    }

    public void setMinAttackInterval(int pAttackCooldown) {
        this.attackIntervalMin = pAttackCooldown;
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity != null && livingentity.m_6084_()) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.m_8036_() || this.target != null && this.target.m_6084_() && !this.mob.m_21573_().m_26571_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity != null) {
            boolean flag1;
            double d0 = this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
            boolean flag = this.mob.m_21574_().m_148306_((Entity)livingentity);
            boolean bl = flag1 = this.seeTime > 0;
            if (flag != flag1) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
                this.mob.m_21573_().m_26573_();
                ++this.strafingTime;
            } else {
                this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (d0 > (double)(this.attackRadiusSqr * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (d0 < (double)(this.attackRadiusSqr * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.mob.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
            } else {
                this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
            }
            if (--this.attackTime == 0) {
                if (!flag) {
                    return;
                }
                float f = (float)Math.sqrt(d0) / this.attackRadius;
                float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                ((RangedAttackMob)this.mob).m_6504_(this.target, f1);
                this.attackTime = Mth.m_14143_((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.attackTime < 0) {
                this.attackTime = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
            }
        }
    }
}

