/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.zepalesque.redux.data.resource.ReduxBiomeModifiers;
import net.zepalesque.redux.data.resource.ReduxConfiguredCarvers;
import net.zepalesque.redux.data.resource.ReduxDamageTypes;
import net.zepalesque.redux.data.resource.ReduxDensityFunctions;
import net.zepalesque.redux.data.resource.ReduxFeatureConfig;
import net.zepalesque.redux.data.resource.ReduxNoiseSettings;
import net.zepalesque.redux.data.resource.ReduxPlacements;
import net.zepalesque.redux.data.resource.biome.registry.ReduxBiomes;
import org.apache.commons.compress.utils.Lists;

public class ReduxRegistrySets
extends DatapackBuiltinEntriesProvider {
    public static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().m_254916_(Registries.f_268580_, ReduxDamageTypes::bootstrap).m_254916_(Registries.f_257040_, ReduxDensityFunctions::bootstrap).m_254916_(Registries.f_257003_, ReduxConfiguredCarvers::bootstrap).m_254916_(Registries.f_256911_, ReduxFeatureConfig::bootstrap).m_254916_(Registries.f_256988_, ReduxPlacements::bootstrap).m_254916_(Registries.f_256952_, ReduxBiomes::bootstrap).m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, ReduxBiomeModifiers::bootstrap);

    public ReduxRegistrySets(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, RegistrySetBuilder builder, String modid, String ... otherIds) {
        super(output, registries, builder, ReduxRegistrySets.buildModidList(modid, otherIds));
    }

    public static Set<String> buildModidList(String modid, String ... otherIds) {
        ArrayList list = Lists.newArrayList();
        list.add("aether");
        list.add(modid);
        list.addAll(Arrays.stream(otherIds).toList());
        return Set.copyOf(list);
    }

    public static HolderLookup.Provider patchLookup(HolderLookup.Provider lookup) {
        return BUILDER.m_254929_((RegistryAccess)RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_), lookup);
    }

    public static class NoisePack
    extends DatapackBuiltinEntriesProvider {
        public static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().m_254916_(Registries.f_256932_, ReduxNoiseSettings.NoisePack::bootstrap);

        public NoisePack(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, String modid, String ... otherIds) {
            super(output, registries, BUILDER, ReduxRegistrySets.buildModidList(modid, otherIds));
        }
    }
}

