/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.gui.screen.menu;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.client.gui.component.menu.DynamicMenuButton;
import com.aetherteam.aether.client.gui.screen.menu.TitleScreenBehavior;
import com.aetherteam.aether.mixin.mixins.client.accessor.TitleScreenAccessor;
import com.aetherteam.cumulus.mixin.mixins.client.accessor.SplashRendererAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.ForgeHooksClient;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.client.ReduxMenus;
import net.zepalesque.redux.client.gui.component.DynamicImageButton;
import net.zepalesque.redux.client.gui.component.menu.ReduxMenuButton;
import net.zepalesque.redux.config.ReduxConfig;

public class ReduxTitleScreen
extends TitleScreen
implements TitleScreenBehavior {
    private static final ResourceLocation PANORAMA_OVERLAY = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    private static final ResourceLocation REDUX_LOGO = Redux.locate("textures/gui/title/redux.png");
    private final PanoramaRenderer cube;
    private int rows;
    private static final int baseLogoHeight = 144;
    private static final int SPLASH_COLOR = 0xAAAAFF;
    private static final int baseLogoWidth = 288;

    public ReduxTitleScreen() {
        ((TitleScreenAccessor)this).aether$setFading(true);
        this.cube = new PanoramaRenderer(ReduxMenus.DYNAMIC_CUBEMAP);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.setupButtons();
    }

    public void setupButtons() {
        int buttonRows = 0;
        boolean lastY = false;
        Button title = (Button)this.m_142416_(this.logoButton(ReduxTitleScreen.getScale(this, this.getMinecraft())));
        if (((Boolean)AetherConfig.CLIENT.enable_server_button.get()).booleanValue()) {
            Component component = ((TitleScreenAccessor)this).callGetMultiplayerDisabledReason();
            boolean flag = component == null;
            Tooltip tooltip = component != null ? Tooltip.m_257550_((Component)component) : null;
            Button serverButton = this.m_142416_(Button.m_253074_((Component)Component.m_237115_((String)"gui.aether.menu.server"), button -> {
                ServerData serverData = new ServerData("OATS", "oats.aether-mod.net", false);
                ConnectScreen.m_278792_((Screen)this, (Minecraft)this.f_96541_, (ServerAddress)ServerAddress.m_171864_((String)serverData.f_105363_), (ServerData)serverData, (boolean)false);
            }).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 48 + 72, 200, 20).m_257505_(tooltip).m_253136_());
            serverButton.f_93623_ = flag;
            Predicate<AbstractWidget> predicate = abstractWidget -> abstractWidget.m_6035_().equals(Component.m_237115_((String)"menu.multiplayer")) || abstractWidget.m_6035_().equals(Component.m_237115_((String)"menu.online"));
            this.m_6702_().removeIf(button -> {
                AbstractWidget abstractWidget;
                return button instanceof AbstractWidget && predicate.test(abstractWidget = (AbstractWidget)button);
            });
            this.f_169369_.removeIf(button -> {
                AbstractWidget abstractWidget;
                return button instanceof AbstractWidget && predicate.test(abstractWidget = (AbstractWidget)button);
            });
        }
        for (Renderable renderable : this.f_169369_) {
            if (!(renderable instanceof AbstractWidget)) continue;
            AbstractWidget abstractWidget2 = (AbstractWidget)renderable;
            Component buttonText = abstractWidget2.m_6035_();
            if (TitleScreenBehavior.isImageButton((Component)buttonText)) {
                abstractWidget2.f_93624_ = false;
            }
            if (!(abstractWidget2 instanceof ReduxMenuButton)) continue;
            ReduxMenuButton button2 = (ReduxMenuButton)abstractWidget2;
            ++buttonRows;
            if (buttonText.equals(Component.m_237115_((String)"gui.aether.menu.server"))) {
                button2.serverButton = true;
                button2.buttonCountOffset = 2;
            } else {
                button2.buttonCountOffset = buttonRows;
            }
            if (!((Boolean)AetherConfig.CLIENT.enable_server_button.get()).booleanValue() || !buttonText.equals(Component.m_237115_((String)"menu.singleplayer"))) continue;
            ++buttonRows;
        }
        this.rows = buttonRows;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        TitleScreenAccessor titleScreenAccessor = (TitleScreenAccessor)this;
        if (this.f_96541_ != null && titleScreenAccessor.aether$getSplash() == null) {
            titleScreenAccessor.aether$setSplash(this.f_96541_.m_91310_().m_280369_());
        }
        float fadeAmount = super.handleFading(guiGraphics, (TitleScreen)this, titleScreenAccessor, this.cube, PANORAMA_OVERLAY, partialTicks);
        float scale = ReduxTitleScreen.getScale(this, this.getMinecraft());
        int roundedFadeAmount = Mth.m_14167_((float)(fadeAmount * 255.0f)) << 24;
        if ((roundedFadeAmount & 0xFC000000) != 0) {
            SplashRendererAccessor splashRendererAccessor;
            ForgeHooksClient.renderMainMenu((TitleScreen)this, (GuiGraphics)guiGraphics, (Font)this.f_96547_, (int)this.f_96543_, (int)this.f_96544_, (int)roundedFadeAmount);
            if (titleScreenAccessor.aether$getSplash() != null && (splashRendererAccessor = (SplashRendererAccessor)titleScreenAccessor.aether$getSplash()).cumulus$getSplash() != null && !splashRendererAccessor.cumulus$getSplash().isEmpty()) {
                PoseStack poseStack = guiGraphics.m_280168_();
                float splashX = ((Boolean)ReduxConfig.CLIENT.centered_logo.get() != false ? (float)this.f_96543_ / 2.0f : 16.0f * scale + 144.0f / scale) + 144.0f / scale;
                float splashY = (int)(20.0f + 120.0f / scale);
                poseStack.m_85836_();
                poseStack.m_252880_(splashX, splashY, 0.0f);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(-20.0f));
                float textSize = 1.4f - Mth.m_14154_((float)(Mth.m_14031_((float)((float)(Util.m_137550_() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
                textSize = textSize * (200.0f / scale) / ((float)this.f_96547_.m_92895_(splashRendererAccessor.cumulus$getSplash()) + 64.0f / scale);
                poseStack.m_85841_(textSize, textSize, textSize);
                guiGraphics.m_280137_(this.f_96547_, splashRendererAccessor.cumulus$getSplash(), 0, (int)(-16.0f / scale), 0xAAAAFF | roundedFadeAmount);
                poseStack.m_85849_();
            }
            super.renderRightBranding(guiGraphics, (TitleScreen)this, this.f_96547_, roundedFadeAmount);
        }
        int xOffset = this.handleButtonVisibility(this, fadeAmount);
        for (Renderable renderable : this.f_169369_) {
            renderable.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            if (renderable instanceof ReduxMenuButton) {
                ReduxMenuButton aetherButton = (ReduxMenuButton)renderable;
                if (aetherButton.m_5953_(mouseX, mouseY)) {
                    if (aetherButton.hoverOffset < 15) {
                        aetherButton.hoverOffset += 4;
                    }
                } else if (aetherButton.hoverOffset > 0) {
                    aetherButton.hoverOffset -= 4;
                }
            }
            if (!(renderable instanceof DynamicMenuButton)) continue;
            DynamicMenuButton dynamicMenuButton = (DynamicMenuButton)renderable;
            if (!dynamicMenuButton.enabled) continue;
            xOffset -= 24;
        }
        super.handleImageButtons((TitleScreen)this, xOffset);
    }

    private void setupLogo(GuiGraphics guiGraphics, float transparency, float scale) {
        int width = (int)(288.0f / scale);
        int height = (int)(144.0f / scale);
        int logoX = (Boolean)ReduxConfig.CLIENT.centered_logo.get() != false ? (int)((float)(this.f_96543_ / 2) - 144.0f / scale) : (int)(scale * 16.0f);
        int logoY = (int)(0.0f + 10.0f / scale);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, transparency);
        guiGraphics.m_280163_(REDUX_LOGO, logoX, logoY, 0.0f, 0.0f, width, height, width, height);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected ImageButton logoButton(float scale) {
        int width = (int)(288.0f / scale);
        int height = (int)(144.0f / scale);
        int logoX = (Boolean)ReduxConfig.CLIENT.centered_logo.get() != false ? (int)((float)(this.f_96543_ / 2) - 144.0f / scale) : (int)(scale * 16.0f);
        int logoY = (int)(0.0f + 10.0f / scale);
        return new DynamicImageButton(logoX, logoY, width, height, 0, 0, 0, REDUX_LOGO, width, height, button -> ReduxMenus.cycle()).setActiveSupplier(() -> !this.isActuallyFading());
    }

    public static float getScale(ReduxTitleScreen screen, Minecraft minecraft) {
        int guiScale = minecraft.m_91268_().m_85385_(((Integer)minecraft.f_91066_.m_231928_().m_231551_()).intValue(), minecraft.m_91390_());
        return ReduxTitleScreen.calculateScale(screen, guiScale, guiScale - 1);
    }

    public static float calculateScale(ReduxTitleScreen screen, float guiScale, float lowerScale) {
        int range;
        float scale = 1.0f;
        if (guiScale > 1.0f) {
            scale = guiScale / lowerScale;
        }
        if ((range = ReduxMenuButton.totalHeightRange(screen.rows, scale)) > screen.f_96544_ && scale != 1.0f) {
            return ReduxTitleScreen.calculateScale(screen, guiScale, lowerScale - 1.0f);
        }
        return scale;
    }

    protected <T extends GuiEventListener & Renderable> T m_142416_(T renderable) {
        Button button;
        if (renderable instanceof Button && TitleScreenBehavior.isMainButton((Component)(button = (Button)renderable).m_6035_())) {
            ReduxMenuButton aetherButton = new ReduxMenuButton(this, button);
            return (T)super.m_142416_((GuiEventListener)aetherButton);
        }
        return (T)super.m_142416_(renderable);
    }

    public void m_7379_() {
        super.m_7379_();
    }

    protected boolean isActuallyFading() {
        return Util.m_137550_() - ((TitleScreenAccessor)this).aether$getFadeInStart() < 1000L;
    }
}

