/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.api.predicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;

public record MusicPredicate(Optional<HolderSet<SoundEvent>> sounds, Optional<List<Integer>> minDelays, Optional<List<Integer>> maxDelays, Optional<Boolean> replaceCurrent) implements Predicate<Music>
{
    public static final Codec<HolderSet<SoundEvent>> SOUND_EVENT_SET = RegistryCodecs.m_206279_((ResourceKey)Registries.f_256840_, (Codec)SoundEvent.f_263124_);
    public static final Codec<MusicPredicate> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)SOUND_EVENT_SET.optionalFieldOf("sounds").forGetter(MusicPredicate::sounds), (App)Codec.INT.listOf().optionalFieldOf("valid_min_delays").forGetter(MusicPredicate::minDelays), (App)Codec.INT.listOf().optionalFieldOf("valid_max_delays").forGetter(MusicPredicate::maxDelays), (App)Codec.BOOL.optionalFieldOf("replaces_current").forGetter(MusicPredicate::replaceCurrent)).apply((Applicative)builder, MusicPredicate::new));

    @Override
    public boolean test(Music music) {
        if (this.sounds.isPresent() && !this.sounds.get().m_203333_(music.m_263193_())) {
            return false;
        }
        if (this.minDelays.isPresent() && !this.minDelays.get().isEmpty() && !this.minDelays.get().contains(music.m_11636_())) {
            return false;
        }
        if (this.maxDelays.isPresent() && !this.maxDelays.get().isEmpty() && !this.maxDelays.get().contains(music.m_11639_())) {
            return false;
        }
        return this.replaceCurrent.isEmpty() || music.m_11642_() == this.replaceCurrent.get().booleanValue();
    }
}

