/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.api.packconfig;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Objects;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.api.packconfig.IConfigSaving;
import net.zepalesque.redux.api.packconfig.PackConfig;
import net.zepalesque.redux.api.packconfig.PackConfigBootstrap;
import org.jetbrains.annotations.Nullable;

public class Category
implements IConfigSaving {
    private final String id;
    @Nullable
    private final Category parent;
    public Map<String, IConfigSaving> members = Maps.newHashMap();

    Category(String id, @Nullable Category parent) {
        this.id = id;
        this.parent = parent;
    }

    public void addMember(IConfigSaving member) {
        this.members.put(member.id(), member);
    }

    @Override
    @Nullable
    public Category parent() {
        return this.parent;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public JsonElement write() {
        JsonObject json = new JsonObject();
        for (Map.Entry<String, IConfigSaving> entry : this.members.entrySet()) {
            json.add(entry.getKey(), entry.getValue().write());
        }
        return json;
    }

    public void save() {
        PackConfigBootstrap.write(this.getRoot().id(), this.getRoot().write());
    }

    public Category getRoot() {
        return Objects.requireNonNullElse(this.parent, this);
    }

    public Category getOrCreate(String id) {
        if (this.members.containsKey(id)) {
            IConfigSaving val = this.members.get(id);
            if (val instanceof Category) {
                Category coll = (Category)val;
                return coll;
            }
            throw new ClassCastException("Cannot convert a PackCfg to a CfgCollection!");
        }
        Category collection = new Category(id, this);
        this.members.put(id, collection);
        return collection;
    }

    public PackConfig.Builder builder() {
        if (this.parent() != null) {
            Redux.LOGGER.warn("Attempting to create builder for non-root config collection!");
        }
        return new PackConfig.Builder(this);
    }

    @Override
    public void read(JsonElement json) {
        if (json instanceof JsonObject) {
            JsonObject obj = (JsonObject)json;
            for (Map.Entry<String, IConfigSaving> entry : this.members.entrySet()) {
                if (!obj.has(entry.getKey())) continue;
                JsonElement val = obj.get(entry.getKey());
                entry.getValue().read(val);
            }
        }
    }
}

