/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.api.condition;

import com.aetherteam.aether.data.ConfigSerializationUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraftforge.common.ForgeConfigSpec;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.api.condition.AbstractCondition;
import net.zepalesque.redux.api.condition.ConditionSerializers;

public class AetherConfigCondition
implements AbstractCondition<AetherConfigCondition> {
    public static final Codec<AetherConfigCondition> CODEC = RecordCodecBuilder.create(condition -> condition.group((App)Codec.STRING.fieldOf("config_path").forGetter(config -> ConfigSerializationUtil.serialize(config.config))).apply((Applicative)condition, AetherConfigCondition::fromText));
    protected final ForgeConfigSpec.ConfigValue<Boolean> config;

    public static AetherConfigCondition fromText(String config) {
        return new AetherConfigCondition((ForgeConfigSpec.ConfigValue<Boolean>)ConfigSerializationUtil.deserialize((String)config));
    }

    public AetherConfigCondition(ForgeConfigSpec.ConfigValue<Boolean> config) {
        this.config = config;
    }

    @Override
    public boolean isConditionMet() {
        if (this.config == null) {
            Redux.LOGGER.warn("Config Condition value was null! Printing stack trace...");
            Thread.dumpStack();
        }
        return this.config != null && (Boolean)this.config.get() != false;
    }

    @Override
    public Codec<AetherConfigCondition> codec() {
        return (Codec)ConditionSerializers.AETHER_CONFIG.get();
    }

    @Override
    public String text() {
        return "AetherConfigCondition{config='" + this.config.toString() + "'}";
    }
}

