/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.attachment;

import cofh.lib.api.control.IRedstoneControllable;
import cofh.lib.util.Constants;
import cofh.lib.util.Utils;
import cofh.thermal.dynamics.attachment.IRedstoneControllableAttachment;
import cofh.thermal.dynamics.common.network.packet.server.AttachmentRedstoneControlPacket;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;

public class RedstoneControlLogic
implements IRedstoneControllable {
    protected IRedstoneControllableAttachment attachment;
    protected Supplier<Boolean> enabled;
    protected int power;
    protected int threshold;
    protected IRedstoneControllable.ControlMode mode = IRedstoneControllable.ControlMode.DISABLED;

    public RedstoneControlLogic(IRedstoneControllableAttachment attachment) {
        this(attachment, Constants.TRUE);
    }

    public RedstoneControlLogic(IRedstoneControllableAttachment attachment, Supplier<Boolean> enabled) {
        this.attachment = attachment;
        this.enabled = enabled;
    }

    public RedstoneControlLogic setEnabled(Supplier<Boolean> enabled) {
        this.enabled = enabled;
        return this;
    }

    public void readFromBuffer(FriendlyByteBuf buffer) {
        this.power = buffer.readByte();
        this.threshold = buffer.readByte();
        this.mode = IRedstoneControllable.ControlMode.VALUES[buffer.readByte()];
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.writeByte(this.power);
        buffer.writeByte(this.threshold);
        buffer.writeByte(this.mode.ordinal());
    }

    public RedstoneControlLogic read(CompoundTag nbt) {
        CompoundTag subTag = nbt.m_128469_("RSControl");
        if (!subTag.m_128456_()) {
            this.power = subTag.m_128445_("RSPower");
            this.threshold = subTag.m_128445_("RSThreshold");
            this.mode = !this.isControllable() ? IRedstoneControllable.ControlMode.DISABLED : IRedstoneControllable.ControlMode.VALUES[subTag.m_128445_("RSMode")];
        }
        return this;
    }

    public CompoundTag write(CompoundTag nbt) {
        if (this.isControllable()) {
            CompoundTag subTag = new CompoundTag();
            subTag.m_128344_("RSPower", (byte)this.power);
            subTag.m_128344_("RSThreshold", (byte)this.threshold);
            subTag.m_128344_("RSMode", (byte)this.mode.ordinal());
            nbt.m_128365_("RSControl", (Tag)subTag);
        }
        return nbt;
    }

    public RedstoneControlLogic readSettings(CompoundTag nbt) {
        CompoundTag subTag = nbt.m_128469_("RSControl");
        if (!subTag.m_128456_() && this.isControllable()) {
            this.threshold = subTag.m_128445_("RSThreshold");
            this.mode = !this.isControllable() ? IRedstoneControllable.ControlMode.DISABLED : IRedstoneControllable.ControlMode.VALUES[subTag.m_128445_("RSMode")];
        }
        return this;
    }

    public CompoundTag writeSettings(CompoundTag nbt) {
        if (this.isControllable()) {
            CompoundTag subTag = new CompoundTag();
            subTag.m_128344_("RSThreshold", (byte)this.threshold);
            subTag.m_128344_("RSMode", (byte)this.mode.ordinal());
            nbt.m_128365_("RSControl", (Tag)subTag);
        }
        return nbt;
    }

    public boolean isControllable() {
        return this.enabled.get();
    }

    public int getPower() {
        return this.power;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public IRedstoneControllable.ControlMode getMode() {
        return this.mode;
    }

    public void setPower(int power) {
        this.power = power;
    }

    public void setControl(int threshold, IRedstoneControllable.ControlMode mode) {
        int curThreshold = this.threshold;
        IRedstoneControllable.ControlMode curMode = this.mode;
        this.threshold = threshold;
        this.mode = mode;
        if (Utils.isClientWorld((Level)this.attachment.world())) {
            AttachmentRedstoneControlPacket.sendToServer(this.attachment);
            this.threshold = curThreshold;
            this.mode = curMode;
        } else {
            this.attachment.onControlUpdate();
        }
    }
}

