/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.init;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.core.v1.ModContainerHelper;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.init.v2.builder.ExtendedMenuSupplier;
import fuzs.puzzleslib.api.init.v3.RegistryHelper;
import fuzs.puzzleslib.impl.init.RegistryManagerV3Impl;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ObjectHolderRegistry;
import org.jetbrains.annotations.Nullable;

public final class ForgeRegistryManagerV3
extends RegistryManagerV3Impl {
    @Nullable
    private final IEventBus eventBus;
    private final Map<ResourceKey<? extends Registry<?>>, DeferredRegister<?>> registers = Maps.newIdentityHashMap();

    public ForgeRegistryManagerV3(String modId) {
        super(modId);
        this.eventBus = ModContainerHelper.getOptionalModEventBus(modId).orElse(null);
    }

    @Override
    public <T> Holder.Reference<T> getHolder(ResourceKey<? extends Registry<? super T>> registryKey, String path) {
        Registry registry = RegistryHelper.findBuiltInRegistry(registryKey);
        ResourceKey resourceKey = this.makeResourceKey(registryKey, path);
        Holder.Reference holder = Holder.Reference.m_254896_((HolderOwner)registry.m_255303_(), resourceKey);
        ObjectHolderRegistry.addHandler(predicate -> {
            if (predicate.test(registryKey.m_135782_()) && !holder.m_203633_()) {
                Object value = registry.m_6246_(resourceKey);
                Objects.requireNonNull(value, "value is null");
                holder.m_247654_(value);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> holder.m_205769_(registry.m_203636_(resourceKey).stream().flatMap(Holder.Reference::m_203616_).toList()));
        if (ModLoaderEnvironment.INSTANCE.isClient()) {
            MinecraftForge.EVENT_BUS.addListener(evt -> {
                if (evt.getConnection().m_129531_()) {
                    return;
                }
                holder.m_205769_(Set.of());
            });
        }
        return holder;
    }

    @Override
    protected <T> Holder.Reference<T> _register(ResourceKey<? extends Registry<? super T>> registryKey, String path, Supplier<T> supplier) {
        DeferredRegister register = this.registers.computeIfAbsent(registryKey, $ -> {
            DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)registryKey, (String)this.modId);
            Objects.requireNonNull(this.eventBus, "mod event bus for %s is null".formatted(this.modId));
            deferredRegister.register(this.eventBus);
            return deferredRegister;
        });
        register.register(path, () -> {
            Object value = supplier.get();
            Objects.requireNonNull(value, "value is null");
            return value;
        });
        return this.getHolder(registryKey, path);
    }

    @Override
    public Holder.Reference<Item> registerSpawnEggItem(Holder.Reference<? extends EntityType<? extends Mob>> entityTypeReference, int backgroundColor, int highlightColor, Item.Properties itemProperties) {
        return this.registerItem(entityTypeReference.m_205785_().m_135782_().m_135815_() + "_spawn_egg", () -> new ForgeSpawnEggItem((Supplier)entityTypeReference, backgroundColor, highlightColor, itemProperties));
    }

    @Override
    public <T extends AbstractContainerMenu> Holder.Reference<MenuType<T>> registerExtendedMenuType(String path, Supplier<ExtendedMenuSupplier<T>> entry) {
        return this.register(Registries.f_256798_, path, () -> IForgeMenuType.create(((ExtendedMenuSupplier)entry.get())::create));
    }

    @Override
    public Holder.Reference<PoiType> registerPoiType(String path, Supplier<Set<BlockState>> matchingStates, int maxTickets, int validRange) {
        return this.register(Registries.f_256805_, path, () -> new PoiType((Set)matchingStates.get(), maxTickets, validRange));
    }
}

