/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtaether.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.block.branch.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.systems.nodemapper.FindEndsNode;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class JellyshroomBranchesGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> BLOCK = ConfigurationProperty.block((String)"block");
    public static final ConfigurationProperty<Integer> BLOCKS_PER_BRANCH = ConfigurationProperty.integer((String)"blocks_per_branch");

    public JellyshroomBranchesGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{BLOCK, PLACE_CHANCE, BLOCKS_PER_BRANCH});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(BLOCK, (Object)Blocks.f_50016_)).with(BLOCKS_PER_BRANCH, (Object)10)).with(PLACE_CHANCE, (Object)Float.valueOf(0.1f));
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        BlockPos.MutableBlockPos testPos = context.pos().m_7494_().m_122032_();
        int h = 0;
        while (TreeHelper.isBranch((BlockState)context.level().m_8055_((BlockPos)testPos))) {
            ++h;
            testPos.m_122184_(0, 1, 0);
        }
        if (h == 0) {
            return false;
        }
        return this.placeAllSideBranches(h, (Integer)configuration.get(BLOCKS_PER_BRANCH), 1.0f, context.level(), context.pos(), (Block)configuration.get(BLOCK), true);
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (!context.natural() || context.fertility() == 0) {
            return false;
        }
        BlockPos rootPos = context.pos();
        FindEndsNode endFinder = new FindEndsNode();
        TreeHelper.startAnalysisFromRoot((LevelAccessor)context.level(), (BlockPos)rootPos, (MapSignal)new MapSignal(new NodeInspector[]{endFinder}));
        List endPoints = endFinder.getEnds();
        if (endPoints.isEmpty()) {
            return false;
        }
        int height = ((BlockPos)endPoints.get(0)).m_123342_() - rootPos.m_123342_();
        return this.placeAllSideBranches(height, (Integer)configuration.get(BLOCKS_PER_BRANCH), ((Float)configuration.get(PLACE_CHANCE)).floatValue(), context.level(), context.pos(), (Block)configuration.get(BLOCK), false);
    }

    private boolean placeAllSideBranches(int height, int hash, float chance, LevelAccessor level, BlockPos rootPos, Block block, boolean worldgen) {
        for (int y = 2; y < height; ++y) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos pos = rootPos.m_6630_(y).m_121955_(dir.m_122436_());
                BlockState existing = level.m_8055_(pos);
                if (CoordUtils.coordHashCode((BlockPos)pos, (int)2) % hash != 0 || !existing.m_247087_() && !(existing.m_60734_() instanceof TrunkShellBlock) || !(level.m_213780_().m_188501_() < chance)) continue;
                level.m_7731_(pos, block.m_49966_(), 3);
                if (worldgen) continue;
                return true;
            }
        }
        return true;
    }
}

