/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common.item;

import cofh.core.common.item.ITrackedItem;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cofh_core")
public class ItemTracker {
    protected static Map<Hand, ItemStack> HELD = new Object2ObjectOpenHashMap();
    protected static Object2IntMap<ItemStack> USING = new Object2IntOpenHashMap();

    public static int getUsingDuration(ItemStack stack) {
        return USING.getInt((Object)stack);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        ItemTracker.updateData(player, InteractionHand.MAIN_HAND);
        ItemTracker.updateData(player, InteractionHand.OFF_HAND);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onStartUsing(LivingEntityUseItemEvent.Start event) {
        if (!event.isCanceled()) {
            ItemTracker.updateUsing(event.getItem(), event.getDuration());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTickUsing(LivingEntityUseItemEvent.Tick event) {
        if (!event.isCanceled()) {
            ItemTracker.updateUsing(event.getItem(), event.getDuration());
        }
    }

    @SubscribeEvent
    public static void onEndUsing(LivingEntityUseItemEvent.Stop event) {
        ItemTracker.stopUsing(event.getItem());
    }

    @SubscribeEvent
    public static void onFinishUsing(LivingEntityUseItemEvent.Finish event) {
        ItemTracker.stopUsing(event.getItem());
    }

    protected static void updateData(Player player, InteractionHand hand) {
        ITrackedItem item;
        Item item2;
        Hand key = new Hand(player, hand);
        ItemStack previous = HELD.remove(key);
        int duration = USING.removeInt((Object)previous);
        ItemStack current = player.m_21120_(hand);
        if (previous != null && (item2 = previous.m_41720_()) instanceof ITrackedItem) {
            item = (ITrackedItem)item2;
            if (item.matches(previous, current)) {
                HELD.put(key, current);
                USING.put((Object)current, duration);
                return;
            }
            item.onSwapFrom(player, hand, previous, current, duration);
        }
        if ((item2 = current.m_41720_()) instanceof ITrackedItem) {
            item = (ITrackedItem)item2;
            HELD.put(key, current);
            USING.put((Object)current, duration);
            item.onSwapTo(player, hand, previous, current);
        }
    }

    protected static void updateUsing(ItemStack stack, int duration) {
        USING.computeIntIfPresent((Object)stack, (key, old) -> stack.m_41779_() - duration);
    }

    protected static void stopUsing(ItemStack stack) {
        USING.computeIntIfPresent((Object)stack, (key, old) -> -1);
    }

    static {
        USING.defaultReturnValue(-1);
    }

    protected record Hand(Player player, InteractionHand hand) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Hand) {
                Hand other = (Hand)o;
                return this.player.equals((Object)other.player) && this.player.m_7578_() == other.player.m_7578_() && this.hand.equals((Object)other.hand);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.player.m_7578_(), this.player, this.hand);
        }
    }
}

