/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common.entity;

import cofh.core.init.CoreMobEffects;
import cofh.core.util.AreaUtils;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.common.entity.AbstractAoESpell;
import cofh.lib.util.helpers.MathHelper;
import java.util.SplittableRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2i;

public abstract class Shockwave
extends AbstractAoESpell {
    protected final SplittableRandom rand = new SplittableRandom();

    public Shockwave(EntityType<? extends Shockwave> type, Level level) {
        super((EntityType<? extends AbstractAoESpell>)type, level);
    }

    public Shockwave(EntityType<? extends Shockwave> type, Level level, Vec3 pos, Entity owner, float power) {
        super((EntityType<? extends AbstractAoESpell>)type, level, pos, owner, power);
    }

    @Override
    public void activeTick() {
        if (this.f_19853_.m_5776_()) {
            BlockPos center = this.m_20183_();
            float speed = this.getSpeed();
            float radius = this.getRadius();
            BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos above = new BlockPos.MutableBlockPos();
            VFXHelper.SHOCKWAVE_OFFSETS.subMap(Math.min((float)this.f_19797_ * speed, radius), Math.min((float)(this.f_19797_ + 1) * speed, radius)).values().forEach(offs -> {
                block0: for (Vector2i offset : offs) {
                    if (!this.rand.nextBoolean()) continue;
                    for (int y = 1; y >= -1; --y) {
                        cursor.m_122178_(center.m_123341_() + offset.x, center.m_123342_() + y, center.m_123343_() + offset.y);
                        BlockState state = this.f_19853_.m_8055_((BlockPos)cursor);
                        if (state.m_60795_() || !state.m_60796_((BlockGetter)this.f_19853_, (BlockPos)cursor) || !state.m_60838_((BlockGetter)this.f_19853_, (BlockPos)cursor) || state.m_155947_()) continue;
                        above.m_122178_(cursor.m_123341_(), cursor.m_123342_() + 1, cursor.m_123343_());
                        if (this.f_19853_.m_8055_((BlockPos)above).m_60838_((BlockGetter)this.f_19853_, (BlockPos)above)) continue;
                        this.f_19853_.m_142052_((BlockPos)cursor, state);
                        continue block0;
                    }
                }
            });
        } else if (this.f_19797_ < this.getBaseDuration() && this.attack()) {
            this.onHit();
        }
    }

    public float getSpeed() {
        return 1.0f;
    }

    protected int getBaseDuration() {
        return MathHelper.ceil(this.getRadius() / this.getSpeed());
    }

    @Override
    public int getDuration() {
        return this.getBaseDuration() + 5;
    }

    @Override
    public float getRadius() {
        return this.m_20205_() * 0.5f;
    }

    public int getDebuffDuration() {
        return 100;
    }

    public boolean attack() {
        boolean hitSomething = false;
        float speed = this.getSpeed();
        float dist = (float)this.f_19797_ * speed;
        float r = speed * 0.75f;
        float r2 = r * r;
        float strength = this.getPower() / Math.max(r * 0.25f, 1.0f);
        float damage = this.getDamageMultiplier() * strength;
        Vec3 pos = this.m_20182_();
        Entity owner = this.m_19749_();
        for (LivingEntity entity : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_(), EntitySelector.f_20406_)) {
            DamageSource source;
            if (entity.equals((Object)owner)) continue;
            Vec3 relPos = entity.m_20182_().m_82546_(pos);
            Vec3 center = new Vec3(relPos.f_82479_, 0.0, relPos.f_82481_).m_82541_().m_82490_((double)dist).m_82549_(pos);
            if (AreaUtils.closestPointOnAABB(center, entity.m_20191_()).m_82546_(center).m_165925_() > (double)r2 || !entity.m_6469_(source = this.getDamageSource(center), damage)) continue;
            hitSomething = true;
            entity.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.SUNDERED.get(), this.getDebuffDuration(), MathHelper.weightedRound((double)strength, this.f_19796_) - 1, false, false));
            entity.m_147240_((double)0.8f, -relPos.m_7096_(), -relPos.m_7094_());
        }
        return hitSomething;
    }

    protected float getDamageMultiplier() {
        return 8.0f;
    }

    protected void onHit() {
    }

    protected abstract DamageSource getDamageSource(Vec3 var1);
}

