/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class NbtOutputRecipe {
    public static final RecipeSerializer<Recipe<?>> SERIALIZER = new Serializer();

    private static class Serializer
    implements RecipeSerializer<Recipe<?>> {
        private Serializer() {
        }

        @NotNull
        public Recipe<?> m_6729_(@NotNull ResourceLocation resourceLocation, @NotNull JsonObject jsonObject) {
            Recipe recipe = RecipeManager.m_44045_((ResourceLocation)resourceLocation, (JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"recipe"));
            JsonElement nbt = jsonObject.get("nbt");
            if (nbt == null) {
                throw new JsonSyntaxException("No nbt tag");
            }
            try {
                CompoundTag tag = TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)nbt, (String)"nbt"));
                recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41751_(tag);
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException("Invalid nbt tag: " + e.getMessage(), (Throwable)e);
            }
            return recipe;
        }

        @NotNull
        public Recipe<?> m_8005_(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            throw new IllegalStateException("NbtOutputRecipe should not be sent over network");
        }

        public void m_6178_(@NotNull FriendlyByteBuf buffer, @NotNull Recipe<?> recipe) {
            throw new IllegalStateException("NbtOutputRecipe should not be sent over network");
        }
    }
}

