/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.worldgen.feature.configurations.BOPTreeConfiguration;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;

public abstract class BOPTreeFeature<FC extends BOPTreeConfiguration>
extends TreeFeature {
    protected BOPTreeFeature(Codec<FC> codec) {
        super(codec);
    }

    public boolean placeLeaves(LevelAccessor level, BlockPos pos, FoliagePlacer.FoliageSetter leaves, FC config) {
        if (this.canReplace(level, pos)) {
            leaves.m_271838_(pos, ((BOPTreeConfiguration)((Object)config)).f_161213_.m_213972_(level.m_213780_(), pos));
            return true;
        }
        return false;
    }

    public boolean placeAltLeaves(LevelAccessor level, BlockPos pos, FoliagePlacer.FoliageSetter leaves, FC config) {
        if (this.canReplace(level, pos)) {
            leaves.m_271838_(pos, ((BOPTreeConfiguration)((Object)config)).altFoliageProvider.m_213972_(level.m_213780_(), pos));
            return true;
        }
        return false;
    }

    public boolean placeLog(LevelAccessor world, BlockPos pos, BiConsumer<BlockPos, BlockState> logs, FC config) {
        return this.placeLog(world, pos, null, logs, config);
    }

    public boolean placeLog(LevelAccessor level, BlockPos pos, Direction.Axis axis, BiConsumer<BlockPos, BlockState> logs, FC config) {
        BlockState directedLog;
        Property logAxisProperty = this.getLogAxisProperty(level, pos, config);
        BlockState log = ((BOPTreeConfiguration)((Object)config)).f_68185_.m_213972_(level.m_213780_(), pos);
        BlockState blockState = directedLog = axis != null && logAxisProperty != null ? (BlockState)log.m_61124_(logAxisProperty, (Comparable)axis) : log;
        if (this.canReplace(level, pos)) {
            logs.accept(pos, directedLog);
            return true;
        }
        return false;
    }

    public boolean setVine(LevelAccessor world, RandomSource rand, BlockPos pos, Direction side, int length, FC config) {
        BlockState vine = ((BOPTreeConfiguration)((Object)config)).vineProvider.m_213972_(rand, pos);
        BlockState directedVine = vine.m_60734_() instanceof VineBlock ? (BlockState)((BlockState)((BlockState)((BlockState)vine.m_61124_((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(side == Direction.NORTH))).m_61124_((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(side == Direction.EAST))).m_61124_((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(side == Direction.SOUTH))).m_61124_((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(side == Direction.WEST)) : vine;
        boolean setOne = false;
        while (world.m_8055_(pos).m_60795_() && length > 0 && rand.m_188503_(12) > 0) {
            this.m_5974_((LevelWriter)world, pos, directedVine);
            setOne = true;
            --length;
            pos = pos.m_7495_();
        }
        return setOne;
    }

    public boolean setHanging(LevelAccessor level, BlockPos pos, FC config) {
        BlockState hanging = ((BOPTreeConfiguration)((Object)config)).hangingProvider.m_213972_(level.m_213780_(), pos);
        if (this.canReplace(level, pos)) {
            this.m_5974_((LevelWriter)level, pos, hanging);
        }
        return false;
    }

    public boolean setTrunkFruit(LevelAccessor level, BlockPos pos, FC config) {
        BlockState trunkFruit = ((BOPTreeConfiguration)((Object)config)).trunkFruitProvider.m_213972_(level.m_213780_(), pos);
        if (trunkFruit == null) {
            return false;
        }
        if (this.canReplace(level, pos)) {
            this.m_5974_((LevelWriter)level, pos, trunkFruit);
        }
        return false;
    }

    protected boolean canReplace(LevelAccessor level, BlockPos pos) {
        return TreeFeature.m_67267_((LevelSimulatedReader)level, (BlockPos)pos) || level.m_7433_(pos, state -> {
            Block block = state.m_60734_();
            return state.m_204336_(BlockTags.f_278411_) || state.m_204336_(BlockTags.f_13104_) || block == Blocks.f_50191_ || block == BOPBlocks.WILLOW_VINE || block == BOPBlocks.DEAD_BRANCH || block == Blocks.f_152543_ || block == BOPBlocks.SPANISH_MOSS || block instanceof BushBlock;
        });
    }

    protected Property getLogAxisProperty(LevelAccessor level, BlockPos pos, FC config) {
        BlockState log = ((BOPTreeConfiguration)((Object)config)).f_68185_.m_213972_(level.m_213780_(), pos);
        for (Property property : log.m_61147_()) {
            Collection allowedValues = property.m_6908_();
            if (!allowedValues.contains(Direction.Axis.X) || !allowedValues.contains(Direction.Axis.Y) || !allowedValues.contains(Direction.Axis.Z)) continue;
            return property;
        }
        return null;
    }

    public static boolean isFree(LevelSimulatedReader level, BlockPos pos) {
        return BOPTreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)pos) || level.m_7433_(pos, state -> state.m_204336_(BlockTags.f_13106_));
    }
}

