/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.platform;

import com.mrcrayfish.framework.api.config.FrameworkConfig;
import com.mrcrayfish.framework.platform.services.IConfigHelper;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.Type;

public class ForgeConfigHelper
implements IConfigHelper {
    private static final Type FRAMEWORK_CONFIG_TYPE = Type.getType(FrameworkConfig.class);

    @Override
    public List<Pair<FrameworkConfig, Object>> getAllFrameworkConfigs() {
        List<ModFileScanData.AnnotationData> annotations = ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> FRAMEWORK_CONFIG_TYPE.equals((Object)a.annotationType())).toList();
        ArrayList<Pair<FrameworkConfig, Object>> configs = new ArrayList<Pair<FrameworkConfig, Object>>();
        annotations.forEach(data -> {
            try {
                Class<?> configClass = Class.forName(data.clazz().getClassName());
                Field field = configClass.getDeclaredField(data.memberName());
                field.setAccessible(true);
                Object object = field.get(null);
                Optional.ofNullable(field.getDeclaredAnnotation(FrameworkConfig.class)).ifPresent(simpleConfig -> configs.add(Pair.of((Object)simpleConfig, (Object)object)));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        });
        return configs;
    }

    @Override
    public Path getGamePath() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public Path getConfigPath() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public String getDefaultConfigPath() {
        return FMLConfig.defaultConfigPath();
    }
}

