/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.systems.mushroomlogic;

import com.ferreusveritas.dynamictrees.systems.poissondisc.PoissonDisc;
import com.ferreusveritas.dynamictrees.systems.poissondisc.Vec2i;
import com.ferreusveritas.dynamictrees.util.SimpleBitmap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.Mth;

public class MushroomCapDisc
extends PoissonDisc {
    public static final int MIN_RADIUS = 1;
    public static final int MAX_RADIUS = 8;
    private static final SimpleBitmap[] cbm = new SimpleBitmap[9];
    private static final SimpleBitmap[] icbm = new SimpleBitmap[9];
    private static final List<List<Vec2i>> precomputedRings;

    public static List<Vec2i> getPrecomputedRing(int radius) {
        return precomputedRings.get(Math.min(Math.max(radius, 1), 8));
    }

    public MushroomCapDisc(int x, int z, int radius) {
        this.set(x, z, radius);
    }

    public PoissonDisc setRadius(int radius) {
        this.radius = Mth.m_14045_((int)radius, (int)1, (int)8);
        return this;
    }

    protected SimpleBitmap getCircleBitmap() {
        return cbm[this.radius];
    }

    protected SimpleBitmap getCircleInteriorBitmap() {
        return icbm[this.radius];
    }

    static {
        int[] circledata = new int[]{0, 72, 1160, 13968, 149713, 1497369, 14375705, 134179609};
        for (int r = 1; r <= 8; ++r) {
            SimpleBitmap whole = MushroomCapDisc.circleBitmapGen((int)r, (int)circledata[r - 1]);
            SimpleBitmap inside = new SimpleBitmap(whole.getWidth(), whole.getHeight());
            for (int z = 0; z < inside.getHeight(); ++z) {
                for (int x = 0; x < inside.getWidth(); ++x) {
                    boolean in;
                    if (r == 1) {
                        in = x == 1 && z == 1;
                    } else {
                        SimpleBitmap previousCircle = cbm[r - 1];
                        in = previousCircle.isPixelOn(x - 1, z - 1);
                    }
                    inside.setPixel(x, z, in ? 1 : 0);
                }
            }
            MushroomCapDisc.cbm[r] = whole;
            MushroomCapDisc.icbm[r] = inside;
        }
        MushroomCapDisc.cbm[0] = cbm[1];
        MushroomCapDisc.icbm[0] = icbm[1];
        precomputedRings = new LinkedList<List<Vec2i>>();
        precomputedRings.add(new LinkedList());
        for (int r = 1; r <= 8; ++r) {
            MushroomCapDisc circle = new MushroomCapDisc(0, 0, r);
            precomputedRings.add(new LinkedList());
            for (int ix = -circle.radius; ix <= circle.radius; ++ix) {
                for (int iz = -circle.radius; iz <= circle.radius; ++iz) {
                    int circleX = circle.x + ix;
                    int circleZ = circle.z + iz;
                    if (!circle.isEdge(circleX, circleZ)) continue;
                    precomputedRings.get(r).add(new Vec2i(circleX, circleZ));
                }
            }
        }
    }
}

