/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.text;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DebugTextRenderer {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.##");
    protected final List<String> lines = new ArrayList<String>();

    private static String format(Object value) {
        if (value instanceof Double || value instanceof Float) {
            return DECIMAL_FORMAT.format(value);
        }
        return value.toString();
    }

    public DebugTextRenderer() {
        this.lines.add("");
    }

    public DebugTextRenderer text(String text) {
        this.lines.set(this.lines.size() - 1, this.lines.get(this.lines.size() - 1) + text);
        return this;
    }

    public DebugTextRenderer detail(String name, Object value) {
        StringBuilder lastLine = new StringBuilder(this.lines.get(this.lines.size() - 1));
        if (!lastLine.isEmpty()) {
            lastLine.append(",");
        }
        if (name.isEmpty()) {
            lastLine.append(DebugTextRenderer.format(value));
        } else {
            lastLine.append(ChatFormatting.YELLOW + name + ChatFormatting.RESET + ":" + DebugTextRenderer.format(value));
        }
        this.lines.set(this.lines.size() - 1, lastLine.toString());
        return this;
    }

    public DebugTextRenderer newLine() {
        this.lines.add("");
        return this;
    }

    public void render(Font font, GuiGraphics graphics) {
        RenderSystem.defaultBlendFunc();
        int top = 2;
        for (String msg : this.lines) {
            if (msg != null && !msg.isEmpty()) {
                int n = 2 + font.m_92895_(msg) + 1;
                Objects.requireNonNull(font);
                graphics.m_280509_(1, top - 1, n, top + 9 - 1, -1873784752);
                graphics.m_280056_(font, msg, 2, top, 0xE0E0E0, false);
            }
            Objects.requireNonNull(font);
            top += 9;
        }
    }
}

