/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.radial;

import java.util.Objects;
import java.util.ServiceLoader;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.radial.RadialData;
import mekanism.api.radial.mode.IRadialMode;
import net.minecraft.resources.ResourceLocation;

@NothingNullByDefault
public interface IRadialDataHelper {
    public static final IRadialDataHelper INSTANCE = ServiceLoader.load(IRadialDataHelper.class).findFirst().orElseThrow(() -> new IllegalStateException("No valid ServiceImpl for IRadialDataHelper found"));

    public <MODE extends Enum<MODE>> RadialData<MODE> dataForEnum(ResourceLocation var1, MODE var2);

    public <MODE extends Enum<MODE>> RadialData<MODE> dataForEnum(ResourceLocation var1, Class<MODE> var2);

    public <MODE extends Enum<MODE>> RadialData<MODE> dataForTruncated(ResourceLocation var1, int var2, MODE var3);

    default public RadialData<IRadialMode> booleanBasedData(ResourceLocation identifier, BooleanRadialModes modes) {
        return this.booleanBasedData(identifier, modes, false);
    }

    public RadialData<IRadialMode> booleanBasedData(ResourceLocation var1, BooleanRadialModes var2, boolean var3);

    public record BooleanRadialModes(IRadialMode falseMode, IRadialMode trueMode) {
        public BooleanRadialModes {
            Objects.requireNonNull(falseMode, "Radial mode representing 'false' cannot be null.");
            Objects.requireNonNull(trueMode, "Radial mode representing 'true' cannot be null.");
        }

        public IRadialMode get(boolean value) {
            return value ? this.trueMode : this.falseMode;
        }
    }
}

