/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.common.items;

import com.smashingmods.chemlib.ChemLib;
import com.smashingmods.chemlib.api.Element;
import com.smashingmods.chemlib.api.MatterState;
import com.smashingmods.chemlib.api.MetalType;
import com.smashingmods.chemlib.client.AbbreviationRenderer;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class ElementItem
extends Item
implements Element {
    private final String elementName;
    private final int atomicNumber;
    private final String abbreviation;
    private final int group;
    private final int period;
    private final MatterState matterState;
    private final MetalType metalType;
    private final boolean artificial;
    private final int color;
    private final List<MobEffectInstance> effects;

    public ElementItem(String pChemicalName, int pAtomicNumber, String pAbbreviation, int pGroup, int pPeriod, MatterState pMatterState, MetalType pMetalType, boolean pArtificial, String pColor, List<MobEffectInstance> pEffects) {
        super(new Item.Properties());
        this.elementName = pChemicalName;
        this.atomicNumber = pAtomicNumber;
        this.abbreviation = pAbbreviation;
        this.group = pGroup;
        this.period = pPeriod;
        this.matterState = pMatterState;
        this.metalType = pMetalType;
        this.artificial = pArtificial;
        this.color = Integer.parseInt(pColor, 16) | 0xFF000000;
        this.effects = pEffects;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(String.format("%s (%d)", this.getAbbreviation(), this.atomicNumber))).m_130940_(ChatFormatting.DARK_AQUA));
        if (!this.getGroupName().isEmpty()) {
            pTooltipComponents.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(this.getGroupName())).m_130940_(ChatFormatting.GRAY));
        }
        pTooltipComponents.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(StringUtils.capitalize((String)this.getNamespace()))).m_130948_(ChemLib.MOD_ID_TEXT_STYLE));
    }

    public String getNamespace() {
        return ((ResourceKey)ForgeRegistries.ITEMS.getResourceKey((Object)this).get()).m_135782_().m_135827_();
    }

    @Override
    public String getChemicalName() {
        return this.elementName;
    }

    @Override
    public int getAtomicNumber() {
        return this.atomicNumber;
    }

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    @Override
    public int getPeriod() {
        return this.period;
    }

    @Override
    public int getGroup() {
        return this.group;
    }

    @Override
    public String getGroupName() {
        return switch (this.atomicNumber) {
            case 1, 6, 7, 8, 15, 16, 34 -> "Reactive Non-Metals";
            case 3, 11, 19, 37, 55, 87 -> "Alkali Metals";
            case 4, 12, 20, 38, 56, 88 -> "Alkaline Earth Metals";
            case 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 72, 73, 74, 75, 76, 77, 78, 79, 80, 104, 105, 106, 107, 108 -> "Transition Metals";
            case 13, 31, 49, 50, 81, 82, 83, 84 -> "Post-Transition Metals";
            case 109, 110, 111, 112, 113, 114, 115, 116, 117, 118 -> "Unknown Properties";
            case 5, 14, 32, 33, 51, 52 -> "Metalloids";
            case 9, 17, 35, 53, 85 -> "Halogens";
            case 2, 10, 18, 36, 54, 86 -> "Noble Gasses";
            case 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71 -> "Lanthanides";
            case 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103 -> "Actinides";
            default -> "";
        };
    }

    @Override
    public MatterState getMatterState() {
        return this.matterState;
    }

    @Override
    public MetalType getMetalType() {
        return this.metalType;
    }

    @Override
    public boolean isArtificial() {
        return this.artificial;
    }

    @Override
    public String getChemicalDescription() {
        return "";
    }

    @Override
    public List<MobEffectInstance> getEffects() {
        return this.effects;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    public int getColor(ItemStack pItemStack, int pTintIndex) {
        return pTintIndex > 0 ? -1 : this.color;
    }

    public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(AbbreviationRenderer.RENDERER);
    }
}

