/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.aeroblender;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class AeroBlenderConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Integer> aetherRegionSize;
        public final ForgeConfigSpec.ConfigValue<Integer> vanillaAetherRegionWeight;
        public static AeroBlenderConfig CONFIG;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.aetherRegionSize = builder.comment("The size of aether biome regions from each mod that uses AeroBlender.").translation("aether_region_size").define("Aether Region Size", (Object)2);
            builder.pop();
            builder.push("general");
            this.vanillaAetherRegionWeight = builder.comment("The weighting of vanilla biome regions in the aether.").translation("vanilla_aether_region_weight").define("Aether Region Weight", (Object)10);
            builder.pop();
        }

        public static void setConfig(AeroBlenderConfig config) {
            CONFIG = config;
        }
    }
}

