/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.commonmark;

import guideme.libs.micromark.Assert;
import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.Construct;
import guideme.libs.micromark.HtmlTagName;
import guideme.libs.micromark.State;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import guideme.libs.micromark.commonmark.BlankLine;
import java.util.List;
import java.util.Objects;

public final class HtmlFlow {
    public static final Construct htmlFlow = new Construct();
    public static final Construct nextBlankConstruct;

    private HtmlFlow() {
    }

    private static List<Tokenizer.Event> resolveToHtmlFlow(List<Tokenizer.Event> events, TokenizeContext context) {
        int index = events.size();
        while (!(index-- <= 0 || events.get(index).isEnter() && Objects.equals(events.get((int)index).token().type, "htmlFlow"))) {
        }
        if (index > 1 && Objects.equals(events.get((int)(index - 2)).token().type, "linePrefix")) {
            events.get((int)index).token().start = events.get((int)(index - 2)).token().start;
            events.get((int)(index + 1)).token().start = events.get((int)(index - 2)).token().start;
            events.subList(index - 2, index).clear();
        }
        return events;
    }

    static {
        HtmlFlow.htmlFlow.name = "htmlFlow";
        HtmlFlow.htmlFlow.tokenize = (context, effects, ok, nok) -> new StateMachine(context, effects, ok, nok)::start;
        HtmlFlow.htmlFlow.resolveTo = HtmlFlow::resolveToHtmlFlow;
        HtmlFlow.htmlFlow.concrete = true;
        nextBlankConstruct = new Construct();
        HtmlFlow.nextBlankConstruct.tokenize = (context, effects, ok, nok) -> new NextBlankStateMachine(context, effects, ok, nok)::start;
        HtmlFlow.nextBlankConstruct.partial = true;
    }

    private static class NextBlankStateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;

        public NextBlankStateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
        }

        private State start(int code) {
            Assert.check(CharUtil.markdownLineEnding(code), "expected a line ending");
            this.effects.exit("htmlFlowData");
            this.effects.enter("lineEndingBlank");
            this.effects.consume(code);
            this.effects.exit("lineEndingBlank");
            return this.effects.attempt.hook(BlankLine.blankLine, this.ok, this.nok);
        }
    }

    private static class StateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;
        private int kind;
        boolean startTag;
        String buffer;
        private int index;
        Integer marker;

        public StateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
        }

        private State start(int code) {
            Assert.check(code == 60, "expected `<`");
            this.effects.enter("htmlFlow");
            this.effects.enter("htmlFlowData");
            this.effects.consume(code);
            return this::open;
        }

        private State open(int code) {
            if (code == 33) {
                this.effects.consume(code);
                return this::declarationStart;
            }
            if (code == 47) {
                this.effects.consume(code);
                return this::tagCloseStart;
            }
            if (code == 63) {
                this.effects.consume(code);
                this.kind = 3;
                return this.context.isInterrupt() ? this.ok : this::continuationDeclarationInside;
            }
            if (CharUtil.asciiAlpha(code)) {
                this.effects.consume(code);
                this.buffer = String.valueOf((char)code);
                this.startTag = true;
                return this::tagName;
            }
            return this.nok.step(code);
        }

        private State declarationStart(int code) {
            if (code == 45) {
                this.effects.consume(code);
                this.kind = 2;
                return this::commentOpenInside;
            }
            if (code == 91) {
                this.effects.consume(code);
                this.kind = 5;
                this.buffer = "CDATA[";
                this.index = 0;
                return this::cdataOpenInside;
            }
            if (CharUtil.asciiAlpha(code)) {
                this.effects.consume(code);
                this.kind = 4;
                return this.context.isInterrupt() ? this.ok : this::continuationDeclarationInside;
            }
            return this.nok.step(code);
        }

        private State commentOpenInside(int code) {
            if (code == 45) {
                this.effects.consume(code);
                return this.context.isInterrupt() ? this.ok : this::continuationDeclarationInside;
            }
            return this.nok.step(code);
        }

        private State cdataOpenInside(int code) {
            if (code == this.buffer.charAt(this.index++)) {
                this.effects.consume(code);
                return this.index == this.buffer.length() ? (this.context.isInterrupt() ? this.ok : this::continuation) : this::cdataOpenInside;
            }
            return this.nok.step(code);
        }

        private State tagCloseStart(int code) {
            if (CharUtil.asciiAlpha(code)) {
                this.effects.consume(code);
                this.buffer = String.valueOf((char)code);
                return this::tagName;
            }
            return this.nok.step(code);
        }

        private State tagName(int code) {
            if (code == Integer.MIN_VALUE || code == 47 || code == 62 || CharUtil.markdownLineEndingOrSpace(code)) {
                if (code != 47 && this.startTag && HtmlTagName.htmlRawNames.contains(this.buffer.toLowerCase())) {
                    this.kind = 1;
                    return this.context.isInterrupt() ? this.ok.step(code) : this.continuation(code);
                }
                if (HtmlTagName.htmlBlockNames.contains(this.buffer.toLowerCase())) {
                    this.kind = 6;
                    if (code == 47) {
                        this.effects.consume(code);
                        return this::basicSelfClosing;
                    }
                    return this.context.isInterrupt() ? this.ok.step(code) : this.continuation(code);
                }
                this.kind = 7;
                return this.context.isInterrupt() && !this.context.isOnLazyLine() ? this.nok.step(code) : (this.startTag ? this.completeAttributeNameBefore(code) : this.completeClosingTagAfter(code));
            }
            if (code == 45 || CharUtil.asciiAlphanumeric(code)) {
                this.effects.consume(code);
                this.buffer = this.buffer + String.valueOf((char)code);
                return this::tagName;
            }
            return this.nok.step(code);
        }

        private State basicSelfClosing(int code) {
            if (code == 62) {
                this.effects.consume(code);
                return this.context.isInterrupt() ? this.ok : this::continuation;
            }
            return this.nok.step(code);
        }

        private State completeClosingTagAfter(int code) {
            if (CharUtil.markdownSpace(code)) {
                this.effects.consume(code);
                return this::completeClosingTagAfter;
            }
            return this.completeEnd(code);
        }

        private State completeAttributeNameBefore(int code) {
            if (code == 47) {
                this.effects.consume(code);
                return this::completeEnd;
            }
            if (code == 58 || code == 95 || CharUtil.asciiAlpha(code)) {
                this.effects.consume(code);
                return this::completeAttributeName;
            }
            if (CharUtil.markdownSpace(code)) {
                this.effects.consume(code);
                return this::completeAttributeNameBefore;
            }
            return this.completeEnd(code);
        }

        private State completeAttributeName(int code) {
            if (code == 45 || code == 46 || code == 58 || code == 95 || CharUtil.asciiAlphanumeric(code)) {
                this.effects.consume(code);
                return this::completeAttributeName;
            }
            return this.completeAttributeNameAfter(code);
        }

        private State completeAttributeNameAfter(int code) {
            if (code == 61) {
                this.effects.consume(code);
                return this::completeAttributeValueBefore;
            }
            if (CharUtil.markdownSpace(code)) {
                this.effects.consume(code);
                return this::completeAttributeNameAfter;
            }
            return this.completeAttributeNameBefore(code);
        }

        private State completeAttributeValueBefore(int code) {
            if (code == Integer.MIN_VALUE || code == 60 || code == 61 || code == 62 || code == 96) {
                return this.nok.step(code);
            }
            if (code == 34 || code == 39) {
                this.effects.consume(code);
                this.marker = code;
                return this::completeAttributeValueQuoted;
            }
            if (CharUtil.markdownSpace(code)) {
                this.effects.consume(code);
                return this::completeAttributeValueBefore;
            }
            this.marker = null;
            return this.completeAttributeValueUnquoted(code);
        }

        private State completeAttributeValueQuoted(int code) {
            if (code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                return this.nok.step(code);
            }
            if (Objects.equals(code, this.marker)) {
                this.effects.consume(code);
                return this::completeAttributeValueQuotedAfter;
            }
            this.effects.consume(code);
            return this::completeAttributeValueQuoted;
        }

        private State completeAttributeValueUnquoted(int code) {
            if (code == Integer.MIN_VALUE || code == 34 || code == 39 || code == 60 || code == 61 || code == 62 || code == 96 || CharUtil.markdownLineEndingOrSpace(code)) {
                return this.completeAttributeNameAfter(code);
            }
            this.effects.consume(code);
            return this::completeAttributeValueUnquoted;
        }

        private State completeAttributeValueQuotedAfter(int code) {
            if (code == 47 || code == 62 || CharUtil.markdownSpace(code)) {
                return this.completeAttributeNameBefore(code);
            }
            return this.nok.step(code);
        }

        private State completeEnd(int code) {
            if (code == 62) {
                this.effects.consume(code);
                return this::completeAfter;
            }
            return this.nok.step(code);
        }

        private State completeAfter(int code) {
            if (CharUtil.markdownSpace(code)) {
                this.effects.consume(code);
                return this::completeAfter;
            }
            return code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code) ? this.continuation(code) : this.nok.step(code);
        }

        private State continuation(int code) {
            if (code == 45 && this.kind == 2) {
                this.effects.consume(code);
                return this::continuationCommentInside;
            }
            if (code == 60 && this.kind == 1) {
                this.effects.consume(code);
                return this::continuationRawTagOpen;
            }
            if (code == 62 && this.kind == 4) {
                this.effects.consume(code);
                return this::continuationClose;
            }
            if (code == 63 && this.kind == 3) {
                this.effects.consume(code);
                return this::continuationDeclarationInside;
            }
            if (code == 93 && this.kind == 5) {
                this.effects.consume(code);
                return this::continuationCharacterDataInside;
            }
            if (CharUtil.markdownLineEnding(code) && (this.kind == 6 || this.kind == 7)) {
                return this.effects.check.hook(nextBlankConstruct, this::continuationClose, this::continuationAtLineEnding).step(code);
            }
            if (code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                return this.continuationAtLineEnding(code);
            }
            this.effects.consume(code);
            return this::continuation;
        }

        private State continuationAtLineEnding(int code) {
            this.effects.exit("htmlFlowData");
            return this.htmlContinueStart(code);
        }

        private State htmlContinueStart(int code) {
            if (code == Integer.MIN_VALUE) {
                return this.done(code);
            }
            if (CharUtil.markdownLineEnding(code)) {
                Construct tempConstruct = new Construct();
                tempConstruct.tokenize = this::htmlLineEnd;
                tempConstruct.partial = true;
                return this.effects.attempt.hook(tempConstruct, this::htmlContinueStart, this::done).step(code);
            }
            this.effects.enter("htmlFlowData");
            return this.continuation(code);
        }

        private State htmlLineEnd(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            State lineStart = code -> context.isOnLazyLine() ? nok.step(code) : ok.step(code);
            return code -> {
                Assert.check(CharUtil.markdownLineEnding(code), "expected eol");
                effects.enter("lineEnding");
                effects.consume(code);
                effects.exit("lineEnding");
                return lineStart;
            };
        }

        private State continuationCommentInside(int code) {
            if (code == 45) {
                this.effects.consume(code);
                return this::continuationDeclarationInside;
            }
            return this.continuation(code);
        }

        private State continuationRawTagOpen(int code) {
            if (code == 47) {
                this.effects.consume(code);
                this.buffer = "";
                return this::continuationRawEndTag;
            }
            return this.continuation(code);
        }

        private State continuationRawEndTag(int code) {
            if (code == 62 && HtmlTagName.htmlRawNames.contains(this.buffer.toLowerCase())) {
                this.effects.consume(code);
                return this::continuationClose;
            }
            if (CharUtil.asciiAlpha(code) && this.buffer.length() < 8) {
                this.effects.consume(code);
                this.buffer = this.buffer + String.valueOf((char)code);
                return this::continuationRawEndTag;
            }
            return this.continuation(code);
        }

        private State continuationCharacterDataInside(int code) {
            if (code == 93) {
                this.effects.consume(code);
                return this::continuationDeclarationInside;
            }
            return this.continuation(code);
        }

        private State continuationDeclarationInside(int code) {
            if (code == 62) {
                this.effects.consume(code);
                return this::continuationClose;
            }
            if (code == 45 && this.kind == 2) {
                this.effects.consume(code);
                return this::continuationDeclarationInside;
            }
            return this.continuation(code);
        }

        private State continuationClose(int code) {
            if (code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                this.effects.exit("htmlFlowData");
                return this.done(code);
            }
            this.effects.consume(code);
            return this::continuationClose;
        }

        private State done(int code) {
            this.effects.exit("htmlFlow");
            return this.ok.step(code);
        }
    }
}

