/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark;

import guideme.libs.micromark.Assert;
import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.Construct;
import guideme.libs.micromark.InitialConstruct;
import guideme.libs.micromark.InterruptedTokenizeContext;
import guideme.libs.micromark.ListUtils;
import guideme.libs.micromark.ParseContext;
import guideme.libs.micromark.Point;
import guideme.libs.micromark.RootTokenizeContext;
import guideme.libs.micromark.State;
import guideme.libs.micromark.Token;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.unist.UnistPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tokenizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Tokenizer.class);
    private final ParseContext parser;
    final InitialConstruct initialize;
    int pointLine;
    private int pointColumn;
    private int pointOffset;
    private int pointIndex = 0;
    private int pointBufferIndex = -1;
    Map<Integer, Integer> columnStart = new HashMap<Integer, Integer>();
    List<Construct> resolveAllConstructs = new ArrayList<Construct>();
    final List<Object> chunks = new ArrayList<Object>();
    private Stack<Token> stack = new Stack();
    private boolean consumed = true;
    final TokenizeContext context;
    private final Effects effects;
    State state;
    private int expectedCode;

    private Tokenizer(ParseContext parser, InitialConstruct initialize, @Nullable UnistPoint from) {
        if (from != null) {
            this.pointLine = from.line();
            this.pointColumn = from.column();
            this.pointOffset = from.offset();
        } else {
            this.pointLine = 1;
            this.pointColumn = 1;
            this.pointOffset = 0;
        }
        this.parser = parser;
        this.initialize = initialize;
        this.context = new RootTokenizeContext(this);
        this.effects = new Effects();
        this.state = initialize.tokenize(this.context, this.effects);
        if (initialize.resolveAll != null) {
            this.resolveAllConstructs.add(initialize);
        }
    }

    public static TokenizeContext create(ParseContext parser, InitialConstruct initialize, @Nullable UnistPoint from) {
        return new Tokenizer((ParseContext)parser, (InitialConstruct)initialize, (UnistPoint)from).context;
    }

    public ParseContext getParser() {
        return this.parser;
    }

    public Point now() {
        return new Point(this.pointLine, this.pointColumn, this.pointOffset, this.pointIndex, this.pointBufferIndex);
    }

    void main() {
        while (this.pointIndex < this.chunks.size()) {
            Object chunk = this.chunks.get(this.pointIndex);
            if (chunk instanceof String) {
                String textChunk = (String)chunk;
                int chunkIndex = this.pointIndex;
                if (this.pointBufferIndex < 0) {
                    this.pointBufferIndex = 0;
                }
                while (this.pointIndex == chunkIndex && this.pointBufferIndex < textChunk.length()) {
                    this.go(textChunk.charAt(this.pointBufferIndex));
                }
                continue;
            }
            this.go((Integer)chunk);
        }
    }

    void go(int code) {
        if (!this.consumed) {
            throw new IllegalStateException("expected character to be consumed");
        }
        this.consumed = false;
        this.expectedCode = code;
        if (this.state == null) {
            throw new IllegalStateException("expected state");
        }
        this.state = this.state.step(code);
    }

    void onsuccessfulconstruct(Construct construct, Info info) {
        this.addResult(construct, info.from);
    }

    void onsuccessfulcheck(Construct construct, Info info) {
        info.restore().run();
    }

    private Hook constructFactory(ReturnHandle onreturn, @Nullable Map<String, Object> fields) {
        return (constructs, returnState, bogusState) -> new HookStateMachineFactory(onreturn, constructs, returnState, bogusState, fields).createFirst();
    }

    void addResult(Construct construct, int from) {
        if (construct.resolveAll != null && !this.resolveAllConstructs.contains(construct)) {
            this.resolveAllConstructs.add(construct);
        }
        if (construct.resolve != null) {
            ListUtils.splice(this.context.getEvents(), from, this.context.getEvents().size() - from, construct.resolve.resolve(ListUtils.slice(this.context.getEvents(), from), this.context));
        }
        if (construct.resolveTo != null) {
            this.context.setEvents(construct.resolveTo.resolve(this.context.getEvents(), this.context));
        }
        if (!construct.partial && !this.context.getEvents().isEmpty() && this.context.getEvents().get(this.context.getEvents().size() - 1).type() != EventType.EXIT) {
            throw new IllegalStateException("expected last token to end");
        }
    }

    Info store() {
        Point startPoint = this.now();
        int startPrevious = this.context.getPrevious();
        Construct startCurrentConstruct = this.context.getCurrentConstruct();
        int startEventsIndex = this.context.getEvents().size();
        Stack<Token> startStack = new Stack<Token>();
        startStack.addAll(this.stack);
        return new Info(() -> {
            this.pointLine = startPoint.line();
            this.pointColumn = startPoint.column();
            this.pointOffset = startPoint.offset();
            this.pointIndex = startPoint._index();
            this.pointBufferIndex = startPoint._bufferIndex();
            this.context.setPrevious(startPrevious);
            this.context.setCurrentConstruct(startCurrentConstruct);
            ListUtils.setLength(this.context.getEvents(), startEventsIndex);
            this.stack = startStack;
            this.accountForPotentialSkip();
        }, startEventsIndex);
    }

    void accountForPotentialSkip() {
        if (this.columnStart.containsKey(this.pointLine) && this.pointColumn < 2) {
            this.pointColumn = this.columnStart.get(this.pointLine);
            this.pointOffset += this.columnStart.get(this.pointLine) - 1;
        }
    }

    String serializeChunks(List<Object> chunks, boolean expandTabs) {
        int index = -1;
        StringBuilder result = new StringBuilder();
        boolean atTab = false;
        block7: while (++index < chunks.size()) {
            Object chunk = chunks.get(index);
            if (chunk instanceof String) {
                String textChunk = (String)chunk;
                result.append(textChunk);
            } else if (chunk instanceof Integer) {
                Integer code = (Integer)chunk;
                switch (code) {
                    case -5: {
                        result.append('\r');
                        break;
                    }
                    case -4: {
                        result.append('\n');
                        break;
                    }
                    case -3: {
                        result.append('\r').append('\n');
                        break;
                    }
                    case -2: {
                        result.append(expandTabs ? (char)' ' : '\t');
                        break;
                    }
                    case -1: {
                        if (!expandTabs && atTab) continue block7;
                        result.append(' ');
                        break;
                    }
                    default: {
                        result.append((char)code.intValue());
                        break;
                    }
                }
            } else {
                throw new IllegalStateException("Expected String or int: " + chunk);
            }
            atTab = Objects.equals(chunk, -2);
        }
        return result.toString();
    }

    public boolean isOnLazyLine() {
        return this.parser.isLazyLine(this.pointLine);
    }

    public class Effects {
        public Hook attempt;
        public Hook check;
        public Hook interrupt;

        public Effects() {
            this.attempt = Tokenizer.this.constructFactory(Tokenizer.this::onsuccessfulconstruct, null);
            this.check = Tokenizer.this.constructFactory(Tokenizer.this::onsuccessfulcheck, null);
            this.interrupt = Tokenizer.this.constructFactory(Tokenizer.this::onsuccessfulcheck, Map.of("interrupt", true));
        }

        public void consume(int code) {
            if (code != Tokenizer.this.expectedCode) {
                throw new IllegalArgumentException("expected given code to equal expected code");
            }
            Assert.check(!Tokenizer.this.consumed, "expected code to not have been consumed: this might be because `return x(code)` instead of `return x` was used");
            if (code == Integer.MIN_VALUE) {
                Assert.check(Tokenizer.this.context.getEvents().size() == 0 || Tokenizer.this.context.getLastEvent().isExit(), "expected last token to be open");
            } else {
                Assert.check(Tokenizer.this.context.getLastEvent().isEnter(), "expected last token to be open");
            }
            if (CharUtil.markdownLineEnding(code)) {
                ++Tokenizer.this.pointLine;
                Tokenizer.this.pointColumn = 1;
                Tokenizer.this.pointOffset = Tokenizer.this.pointOffset + (code == -3 ? 2 : 1);
                Tokenizer.this.accountForPotentialSkip();
            } else if (code != -1) {
                ++Tokenizer.this.pointColumn;
                ++Tokenizer.this.pointOffset;
            }
            if (Tokenizer.this.pointBufferIndex < 0) {
                ++Tokenizer.this.pointIndex;
            } else {
                ++Tokenizer.this.pointBufferIndex;
                if (Tokenizer.this.pointBufferIndex == ((String)Tokenizer.this.chunks.get(Tokenizer.this.pointIndex)).length()) {
                    Tokenizer.this.pointBufferIndex = -1;
                    ++Tokenizer.this.pointIndex;
                }
            }
            Tokenizer.this.context.setPrevious(code);
            Tokenizer.this.consumed = true;
        }

        public Token enter(String type) {
            return this.enter(type, null);
        }

        public Token enter(String type, Token fields) {
            Token token = fields != null ? new Token(fields) : new Token();
            token.type = type;
            token.start = Tokenizer.this.now();
            Tokenizer.this.context.getEvents().add(new Event(EventType.ENTER, token, Tokenizer.this.context));
            Tokenizer.this.stack.add(token);
            return token;
        }

        public Token exit(String type) {
            Assert.check(type != null, "expected string type");
            Assert.check(!type.isEmpty(), "expected non-empty string");
            Assert.check(!Tokenizer.this.stack.isEmpty(), "cannot close w/o open tokens");
            Token token = Tokenizer.this.stack.pop();
            token.end = Tokenizer.this.now();
            Assert.check(type.equals(token.type), "expected exit token to match current token");
            Assert.check(token.start._index() != token.end._index() || token.start._bufferIndex() != token.end._bufferIndex(), "expected non-empty token (`" + type + "`)");
            Tokenizer.this.context.getEvents().add(Event.exit(token, Tokenizer.this.context));
            return token;
        }
    }

    record Info(Runnable restore, int from) {
    }

    @FunctionalInterface
    static interface ReturnHandle {
        public void handle(Construct var1, Info var2);
    }

    public static interface Hook {
        public State hook(List<Construct> var1, State var2, State var3);

        default public State hook(Construct construct, State returnState, State bogusState) {
            return this.hook(List.of(construct), returnState, bogusState);
        }

        default public State hook(Map<Integer, List<Construct>> map, State returnState, State bogusState) {
            return code -> {
                List def = code != Integer.MIN_VALUE ? map.getOrDefault(code, List.of()) : List.of();
                List all = code != Integer.MIN_VALUE ? map.getOrDefault(Integer.MIN_VALUE, List.of()) : List.of();
                ArrayList<Construct> list = new ArrayList<Construct>();
                list.addAll(def);
                list.addAll(all);
                return this.hook(list, returnState, bogusState).step(code);
            };
        }
    }

    public record Event(EventType type, Token token, TokenizeContext context) {
        public static Event enter(Token token, TokenizeContext context) {
            return new Event(EventType.ENTER, token, context);
        }

        public static Event exit(Token token, TokenizeContext context) {
            return new Event(EventType.EXIT, token, context);
        }

        public boolean isEnter() {
            return this.type() == EventType.ENTER;
        }

        public boolean isExit() {
            return this.type() == EventType.EXIT;
        }
    }

    public static enum EventType {
        ENTER,
        EXIT;

    }

    private class HookStateMachineFactory {
        private final List<Construct> constructs;
        @Nullable
        private final Map<String, Object> fields;
        private int constructIndex;
        private Construct currentConstruct;
        private Info info;
        private final State returnState;
        private final State bogusState;
        private final ReturnHandle onreturn;

        public HookStateMachineFactory(ReturnHandle onreturn, List<Construct> constructs, State returnState, @Nullable State bogusState, Map<String, Object> fields) {
            this.constructs = constructs;
            this.fields = fields;
            this.constructIndex = 0;
            this.returnState = returnState;
            this.bogusState = bogusState;
            this.onreturn = onreturn;
        }

        public State createFirst() {
            if (this.constructs.isEmpty()) {
                Assert.check(this.bogusState != null, "expected `bogusState` to be given");
                return this.bogusState;
            }
            return this.create(this.constructs.get(this.constructIndex));
        }

        public State create(Construct construct) {
            return code -> {
                this.info = Tokenizer.this.store();
                this.currentConstruct = construct;
                if (!this.currentConstruct.partial) {
                    Tokenizer.this.context.setCurrentConstruct(construct);
                }
                if (this.currentConstruct.name != null && Tokenizer.this.context.getParser().constructs.nullDisable.contains(this.currentConstruct.name)) {
                    return this.nok(code);
                }
                TokenizeContext useContext = Tokenizer.this.context;
                if (this.fields != null && Boolean.TRUE.equals(this.fields.get("interrupt"))) {
                    useContext = new InterruptedTokenizeContext(Tokenizer.this.context);
                }
                return this.currentConstruct.tokenize.tokenize(useContext, Tokenizer.this.effects, this::ok, this::nok).step(code);
            };
        }

        private State ok(int code) {
            if (code != Tokenizer.this.expectedCode) {
                throw new IllegalStateException("expected code");
            }
            Tokenizer.this.consumed = true;
            this.onreturn.handle(this.currentConstruct, this.info);
            return this.returnState;
        }

        private State nok(int code) {
            Assert.check(code == Tokenizer.this.expectedCode, "expected code");
            Tokenizer.this.consumed = true;
            this.info.restore().run();
            if (++this.constructIndex < this.constructs.size()) {
                return this.create(this.constructs.get(this.constructIndex));
            }
            return this.bogusState;
        }
    }

    public static class ContainerState
    extends HashMap<String, Object> {
    }
}

