/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.function.valuesource;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.queries.function.FunctionValues;
import guideme.internal.shaded.lucene.queries.function.valuesource.DocFreqValueSource;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.similarities.PerFieldSimilarityWrapper;
import guideme.internal.shaded.lucene.search.similarities.Similarity;
import guideme.internal.shaded.lucene.search.similarities.TFIDFSimilarity;
import guideme.internal.shaded.lucene.util.BytesRef;
import java.io.IOException;
import java.util.Map;

public class IDFValueSource
extends DocFreqValueSource {
    public IDFValueSource(String field, String val, String indexedField, BytesRef indexedBytes) {
        super(field, val, indexedField, indexedBytes);
    }

    @Override
    public String name() {
        return "idf";
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        IndexSearcher searcher = (IndexSearcher)context.get("searcher");
        TFIDFSimilarity sim = IDFValueSource.asTFIDF(searcher.getSimilarity(), this.field);
        if (sim == null) {
            throw new UnsupportedOperationException("requires a TFIDFSimilarity (such as ClassicSimilarity)");
        }
        int docfreq = searcher.getIndexReader().docFreq(new Term(this.indexedField, this.indexedBytes));
        float idf = sim.idf(docfreq, searcher.getIndexReader().maxDoc());
        return new DocFreqValueSource.ConstDoubleDocValues(idf, this);
    }

    static TFIDFSimilarity asTFIDF(Similarity sim, String field) {
        while (sim instanceof PerFieldSimilarityWrapper) {
            sim = ((PerFieldSimilarityWrapper)sim).get(field);
        }
        if (sim instanceof TFIDFSimilarity) {
            return (TFIDFSimilarity)sim;
        }
        return null;
    }
}

