/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet.taxonomy;

import guideme.internal.shaded.lucene.facet.taxonomy.AssociationFacetField;
import guideme.internal.shaded.lucene.util.BitUtil;
import guideme.internal.shaded.lucene.util.BytesRef;
import java.util.Arrays;

public class IntAssociationFacetField
extends AssociationFacetField {
    public IntAssociationFacetField(int assoc, String dim, String ... path) {
        super(IntAssociationFacetField.intToBytesRef(assoc), dim, path);
    }

    public static BytesRef intToBytesRef(int v) {
        byte[] bytes = new byte[4];
        BitUtil.VH_BE_INT.set(bytes, 0, v);
        return new BytesRef(bytes);
    }

    public static int bytesRefToInt(BytesRef b) {
        return BitUtil.VH_BE_INT.get(b.bytes, b.offset);
    }

    @Override
    public String toString() {
        return "IntAssociationFacetField(dim=" + this.dim + " path=" + Arrays.toString(this.path) + " value=" + IntAssociationFacetField.bytesRefToInt(this.assoc) + ")";
    }
}

