/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.document;

import guideme.internal.shaded.lucene.document.Field;
import guideme.internal.shaded.lucene.document.FieldType;
import guideme.internal.shaded.lucene.document.XYPointInGeometryQuery;
import guideme.internal.shaded.lucene.geo.XYCircle;
import guideme.internal.shaded.lucene.geo.XYEncodingUtils;
import guideme.internal.shaded.lucene.geo.XYGeometry;
import guideme.internal.shaded.lucene.geo.XYPolygon;
import guideme.internal.shaded.lucene.geo.XYRectangle;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.NumericUtils;

public class XYPointField
extends Field {
    public static final int BYTES = 4;
    public static final FieldType TYPE = new FieldType();

    public void setLocationValue(float x, float y) {
        byte[] bytes;
        if (this.fieldsData == null) {
            bytes = new byte[8];
            this.fieldsData = new BytesRef(bytes);
        } else {
            bytes = ((BytesRef)this.fieldsData).bytes;
        }
        int xEncoded = XYEncodingUtils.encode(x);
        int yEncoded = XYEncodingUtils.encode(y);
        NumericUtils.intToSortableBytes(xEncoded, bytes, 0);
        NumericUtils.intToSortableBytes(yEncoded, bytes, 4);
    }

    public XYPointField(String name, float x, float y) {
        super(name, TYPE);
        this.setLocationValue(x, y);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        byte[] bytes = ((BytesRef)this.fieldsData).bytes;
        result.append(XYEncodingUtils.decode(bytes, 0));
        result.append(',');
        result.append(XYEncodingUtils.decode(bytes, 4));
        result.append('>');
        return result.toString();
    }

    static void checkCompatible(FieldInfo fieldInfo) {
        if (fieldInfo.getPointDimensionCount() != 0 && fieldInfo.getPointDimensionCount() != TYPE.pointDimensionCount()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with numDims=" + fieldInfo.getPointDimensionCount() + " but this point type has numDims=" + TYPE.pointDimensionCount() + ", is the field really a XYPoint?");
        }
        if (fieldInfo.getPointNumBytes() != 0 && fieldInfo.getPointNumBytes() != TYPE.pointNumBytes()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with bytesPerDim=" + fieldInfo.getPointNumBytes() + " but this point type has bytesPerDim=" + TYPE.pointNumBytes() + ", is the field really a XYPoint?");
        }
    }

    public static Query newBoxQuery(String field, float minX, float maxX, float minY, float maxY) {
        XYRectangle rectangle = new XYRectangle(minX, maxX, minY, maxY);
        return new XYPointInGeometryQuery(field, rectangle);
    }

    public static Query newDistanceQuery(String field, float x, float y, float radius) {
        XYCircle circle = new XYCircle(x, y, radius);
        return new XYPointInGeometryQuery(field, circle);
    }

    public static Query newPolygonQuery(String field, XYPolygon ... polygons) {
        return XYPointField.newGeometryQuery(field, polygons);
    }

    public static Query newGeometryQuery(String field, XYGeometry ... xyGeometries) {
        return new XYPointInGeometryQuery(field, xyGeometries);
    }

    static {
        TYPE.setDimensions(2, 4);
        TYPE.freeze();
    }
}

