/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs.lucene90;

import guideme.internal.shaded.lucene.codecs.CodecUtil;
import guideme.internal.shaded.lucene.codecs.LiveDocsFormat;
import guideme.internal.shaded.lucene.index.CorruptIndexException;
import guideme.internal.shaded.lucene.index.IndexFileNames;
import guideme.internal.shaded.lucene.index.SegmentCommitInfo;
import guideme.internal.shaded.lucene.store.ChecksumIndexInput;
import guideme.internal.shaded.lucene.store.Directory;
import guideme.internal.shaded.lucene.store.IOContext;
import guideme.internal.shaded.lucene.store.IndexInput;
import guideme.internal.shaded.lucene.store.IndexOutput;
import guideme.internal.shaded.lucene.util.Bits;
import guideme.internal.shaded.lucene.util.FixedBitSet;
import java.io.IOException;
import java.util.Collection;

public final class Lucene90LiveDocsFormat
extends LiveDocsFormat {
    private static final String EXTENSION = "liv";
    private static final String CODEC_NAME = "Lucene90LiveDocs";
    private static final int VERSION_START = 0;
    private static final int VERSION_CURRENT = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bits readLiveDocs(Directory dir, SegmentCommitInfo info, IOContext context) throws IOException {
        block12: {
            long gen = info.getDelGen();
            String name = IndexFileNames.fileNameFromGeneration(info.info.name, EXTENSION, gen);
            int length = info.info.maxDoc();
            try (ChecksumIndexInput input = dir.openChecksumInput(name, context);){
                Bits bits;
                Throwable priorE = null;
                try {
                    CodecUtil.checkIndexHeader(input, CODEC_NAME, 0, 0, info.info.getId(), Long.toString(gen, 36));
                    FixedBitSet fbs = this.readFixedBitSet(input, length);
                    if (fbs.length() - fbs.cardinality() != info.getDelCount()) {
                        throw new CorruptIndexException("bits.deleted=" + (fbs.length() - fbs.cardinality()) + " info.delcount=" + info.getDelCount(), input);
                    }
                    bits = fbs.asReadOnlyBits();
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                    }
                    catch (Throwable throwable) {
                        CodecUtil.checkFooter(input, priorE);
                        throw throwable;
                    }
                    CodecUtil.checkFooter(input, priorE);
                    break block12;
                }
                CodecUtil.checkFooter(input, priorE);
                return bits;
            }
        }
        throw new AssertionError();
    }

    private FixedBitSet readFixedBitSet(IndexInput input, int length) throws IOException {
        long[] data = new long[FixedBitSet.bits2words(length)];
        for (int i = 0; i < data.length; ++i) {
            data[i] = input.readLong();
        }
        return new FixedBitSet(data, length);
    }

    @Override
    public void writeLiveDocs(Bits bits, Directory dir, SegmentCommitInfo info, int newDelCount, IOContext context) throws IOException {
        int delCount;
        long gen = info.getNextDelGen();
        String name = IndexFileNames.fileNameFromGeneration(info.info.name, EXTENSION, gen);
        try (IndexOutput output = dir.createOutput(name, context);){
            CodecUtil.writeIndexHeader(output, CODEC_NAME, 0, info.info.getId(), Long.toString(gen, 36));
            delCount = this.writeBits(output, bits);
            CodecUtil.writeFooter(output);
        }
        if (delCount != info.getDelCount() + newDelCount) {
            throw new CorruptIndexException("bits.deleted=" + delCount + " info.delcount=" + info.getDelCount() + " newdelcount=" + newDelCount, name);
        }
    }

    private int writeBits(IndexOutput output, Bits bits) throws IOException {
        int delCount = 0;
        int longCount = FixedBitSet.bits2words(bits.length());
        for (int i = 0; i < longCount; ++i) {
            int j;
            long currentBits = 0L;
            int end = Math.min(j + 63, bits.length() - 1);
            for (j = i << 6; j <= end; ++j) {
                if (bits.get(j)) {
                    currentBits |= 1L << j;
                    continue;
                }
                ++delCount;
            }
            output.writeLong(currentBits);
        }
        return delCount;
    }

    @Override
    public void files(SegmentCommitInfo info, Collection<String> files) throws IOException {
        if (info.hasDeletions()) {
            files.add(IndexFileNames.fileNameFromGeneration(info.info.name, EXTENSION, info.getDelGen()));
        }
    }
}

