/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.generic;

import dev.xylonity.bonsai.ghosts.common.entity.ghost.GhostEntity;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class GhostPlaceGoal
extends Goal {
    private final GhostEntity ghost;
    private final Ingredient placeables;
    private final Predicate<BlockState> preference;
    private final int lightThreshold;
    private final int retryCooldown;
    private final double approachSpeed;
    private final double placeRange;
    private long nextTryTick = 0L;
    private BlockPos basePos = null;
    private Vec3 hoverPos = null;
    private int stuckTicks = 0;
    private Vec3 lastPos = null;

    public GhostPlaceGoal(GhostEntity ghost, Ingredient placeables, Predicate<BlockState> pref, int lightThreshold, int retry) {
        this(ghost, placeables, pref, lightThreshold, retry, 1.0, 0.9);
    }

    public GhostPlaceGoal(GhostEntity ghost, Ingredient placeables, Predicate<BlockState> pref, int lightThreshold, int retry, double speed, double range) {
        this.ghost = ghost;
        this.placeables = placeables;
        this.preference = pref;
        this.lightThreshold = lightThreshold;
        this.retryCooldown = Math.max(5, retry);
        this.approachSpeed = speed;
        this.placeRange = range;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.ghost.getMainInteraction() != 1) {
            return false;
        }
        if (this.ghost.m_21825_() || this.ghost.m_20159_()) {
            return false;
        }
        if ((long)this.ghost.f_19797_ < this.nextTryTick) {
            return false;
        }
        ItemStack stack = this.ghost.getHoldItem();
        if (stack.m_41619_() || !this.placeables.test(stack) || !(stack.m_41720_() instanceof BlockItem)) {
            return false;
        }
        BlockPos base = this.findBaseBelow(this.ghost.m_9236_());
        if (base == null) {
            return false;
        }
        Level level = this.ghost.m_9236_();
        BlockPos above = base.m_7494_();
        if (!this.preference.test(level.m_8055_(base))) {
            return false;
        }
        if (!level.m_8055_(above).m_247087_()) {
            return false;
        }
        if (level.m_46803_(above) > this.lightThreshold) {
            return false;
        }
        if (!((BlockItem)stack.m_41720_()).m_40614_().m_49966_().m_60710_((LevelReader)level, above)) {
            return false;
        }
        this.basePos = base;
        this.hoverPos = new Vec3((double)this.basePos.m_123341_() + 0.5, (double)this.basePos.m_123342_() + 1.2, (double)this.basePos.m_123343_() + 0.5);
        this.stuckTicks = 0;
        this.lastPos = this.ghost.m_20182_();
        return true;
    }

    public boolean m_8045_() {
        if (this.ghost.getMainInteraction() != 1) {
            return false;
        }
        if (this.basePos == null || this.hoverPos == null) {
            return false;
        }
        ItemStack stack = this.ghost.getHoldItem();
        if (stack.m_41619_() || !this.placeables.test(stack) || !(stack.m_41720_() instanceof BlockItem)) {
            return false;
        }
        if (!this.ghost.m_9236_().m_8055_(this.basePos.m_7494_()).m_247087_()) {
            return false;
        }
        return this.ghost.m_9236_().m_46803_(this.basePos.m_7494_()) <= this.lightThreshold;
    }

    public void m_8056_() {
        if (this.hoverPos != null) {
            this.ghost.m_21573_().m_26519_(this.hoverPos.f_82479_, this.hoverPos.f_82480_, this.hoverPos.f_82481_, this.approachSpeed);
        }
    }

    public void m_8041_() {
        this.basePos = null;
        this.hoverPos = null;
        this.lastPos = null;
        this.stuckTicks = 0;
        this.ghost.m_21573_().m_26573_();
        this.nextTryTick = this.ghost.f_19797_ + this.retryCooldown;
    }

    public void m_8037_() {
        if (this.hoverPos == null || this.basePos == null) {
            return;
        }
        if (this.lastPos != null) {
            double moved = this.lastPos.m_82554_(this.ghost.m_20182_());
            this.stuckTicks = moved < 0.02 ? ++this.stuckTicks : 0;
        }
        this.lastPos = this.ghost.m_20182_();
        if (this.stuckTicks > 10) {
            this.ghost.m_21573_().m_26519_(this.hoverPos.f_82479_, this.hoverPos.f_82480_, this.hoverPos.f_82481_, this.approachSpeed);
            this.ghost.m_21566_().m_6849_(this.hoverPos.f_82479_, this.hoverPos.f_82480_, this.hoverPos.f_82481_, this.approachSpeed);
            this.stuckTicks = 0;
        }
        this.ghost.m_21563_().m_24946_(this.hoverPos.f_82479_, this.hoverPos.f_82480_, this.hoverPos.f_82481_);
        if (this.ghost.m_20182_().m_82554_(this.hoverPos) <= this.placeRange) {
            this.tryPlace();
        }
    }

    private void tryPlace() {
        Item item;
        if (this.basePos == null) {
            return;
        }
        BlockPos up = this.basePos.m_7494_();
        ItemStack stack = this.ghost.getHoldItem();
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof BlockItem)) {
            this.m_8041_();
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        if (!this.ghost.m_9236_().m_8055_(up).m_247087_() || !blockItem.m_40614_().m_49966_().m_60710_((LevelReader)this.ghost.m_9236_(), up)) {
            this.m_8041_();
            return;
        }
        this.ghost.m_9236_().m_7731_(up, blockItem.m_40614_().m_49966_(), 3);
        stack.m_41774_(1);
        if (stack.m_41619_()) {
            this.ghost.setHoldItem(ItemStack.f_41583_);
        }
        this.m_8041_();
    }

    public boolean m_183429_() {
        return true;
    }

    private BlockPos findBaseBelow(Level level) {
        int gx = (int)Math.floor(this.ghost.m_20185_());
        int gz = (int)Math.floor(this.ghost.m_20189_());
        int gy = (int)Math.floor(this.ghost.m_20186_());
        for (int dy = 0; dy <= 3; ++dy) {
            BlockPos p = new BlockPos(gx, gy - 1 - dy, gz);
            if (level.m_8055_(p).m_60795_()) continue;
            return p;
        }
        return null;
    }
}

