/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dttwilightforest.growthlogic;

import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class CanopyLogic
extends GrowthLogicKit {
    public static final ConfigurationProperty<Integer> CANOPY_HEIGHT = ConfigurationProperty.integer((String)"canopy_height");

    public CanopyLogic(ResourceLocation registryName) {
        super(registryName);
    }

    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(CANOPY_HEIGHT, (Object)6)).with(HEIGHT_VARIATION, (Object)5);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{CANOPY_HEIGHT, HEIGHT_VARIATION});
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = super.populateDirectionProbabilityMap(configuration, context);
        GrowSignal signal = context.signal();
        int lowestBranch = this.getLowestBranchHeight(configuration, new PositionalSpeciesContext(context.level(), signal.rootPos, context.species()));
        if (signal.isInTrunk() && signal.delta.m_123342_() > lowestBranch || signal.delta.m_123342_() >= lowestBranch + (Integer)configuration.get(CANOPY_HEIGHT)) {
            probMap[Direction.UP.ordinal()] = 0;
        }
        probMap[Direction.DOWN.ordinal()] = 0;
        return probMap;
    }

    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return (int)((float)super.getLowestBranchHeight(configuration, context) + this.getHashVariation(configuration, context));
    }

    protected float getHashVariation(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        long day = context.level().m_46467_() / 24000L;
        int month = (int)day / 30;
        return CoordUtils.coordHashCode((BlockPos)context.pos().m_6630_(month), (int)2) % (Integer)configuration.get(HEIGHT_VARIATION);
    }
}

