/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dttwilightforest.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import oshi.util.tuples.Pair;

public class FireflyGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Integer> MIN_RADIUS = ConfigurationProperty.integer((String)"min_radius");
    public static final ConfigurationProperty<Integer> MAX_HEIGHT = ConfigurationProperty.integer((String)"max_height");
    public static final ConfigurationProperty<Integer> WORLDGEN_MAX_COUNT = ConfigurationProperty.integer((String)"worldgen_max_count");
    public static final ConfigurationProperty<Block> BLOCK = ConfigurationProperty.block((String)"block");

    public FireflyGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{MAX_HEIGHT, WORLDGEN_MAX_COUNT, BLOCK, PLACE_CHANCE, MIN_RADIUS});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(MAX_HEIGHT, (Object)20)).with(WORLDGEN_MAX_COUNT, (Object)2)).with(BLOCK, (Object)Blocks.f_50081_)).with(PLACE_CHANCE, (Object)Float.valueOf(0.06f))).with(MIN_RADIUS, (Object)7);
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (context.fertility() > 0 && context.random().m_188501_() < ((Float)configuration.get(PLACE_CHANCE)).floatValue()) {
            this.placeFirefly(configuration, context.level(), context.pos(), 1, context.random());
        }
        return false;
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        int count = context.random().m_188503_((Integer)configuration.get(WORLDGEN_MAX_COUNT) + 1);
        if (count > 0) {
            return this.placeFirefly(configuration, context.level(), context.pos(), count, context.random());
        }
        return false;
    }

    public boolean placeFirefly(GenFeatureConfiguration configuration, LevelAccessor level, BlockPos rootPos, int count, RandomSource rand) {
        List<Pair<BlockPos, Direction>> foundValues = this.findValidPositions(configuration, level, rootPos);
        boolean placed = false;
        for (int i = 0; i < count; ++i) {
            int num = rand.m_188503_(foundValues.size());
            Pair<BlockPos, Direction> pair = foundValues.get(num);
            BlockState placeState = ((Block)configuration.get(BLOCK)).m_49966_();
            if (placeState.m_61138_((Property)DirectionalBlock.f_52588_)) {
                placeState = (BlockState)placeState.m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)((Direction)pair.getB()));
            }
            BlockPos placePos = (BlockPos)pair.getA();
            if (!((Block)configuration.get(BLOCK)).m_7898_(placeState, (LevelReader)level, placePos)) continue;
            level.m_7731_(placePos, placeState, 3);
        }
        return placed;
    }

    public List<Pair<BlockPos, Direction>> findValidPositions(GenFeatureConfiguration configuration, LevelAccessor level, BlockPos rootPos) {
        LinkedList<Pair<BlockPos, Direction>> found = new LinkedList<Pair<BlockPos, Direction>>();
        boolean branchFound = false;
        for (int i = 1; i < (Integer)configuration.get(MAX_HEIGHT); ++i) {
            BlockPos testPos = rootPos.m_6630_(i);
            if (TreeHelper.isBranch((BlockState)level.m_8055_(testPos)) && TreeHelper.getRadius((BlockGetter)level, (BlockPos)testPos) >= (Integer)configuration.get(MIN_RADIUS)) {
                branchFound = true;
            } else if (branchFound) break;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos offsetPos = testPos.m_121955_(dir.m_122436_());
                BlockState state = level.m_8055_(offsetPos);
                if (!state.m_247087_()) continue;
                found.add((Pair<BlockPos, Direction>)new Pair((Object)offsetPos, (Object)dir));
            }
        }
        return found;
    }
}

