/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dttwilightforest.blocks;

import com.ferreusveritas.dynamictrees.block.branch.ThickBranchBlock;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import java.util.HashMap;
import java.util.List;
import maxhyper.dttwilightforest.trees.MagicFamily;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;
import twilightforest.TFConfig;
import twilightforest.data.tags.EntityTagGenerator;
import twilightforest.init.TFBiomes;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;
import twilightforest.item.OreMagnetItem;
import twilightforest.network.ParticlePacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.WorldUtil;

public class MagicCoreBranchBlock
extends ThickBranchBlock {
    protected static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    private final coreType type;
    public static int tickRate = 20;

    public MagicCoreBranchBlock(ResourceLocation name, BlockBehaviour.Properties properties, coreType type) {
        super(name, properties);
        this.type = type;
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{ACTIVE}));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        InteractionResult result = super.m_6227_(state, world, pos, player, handIn, hit);
        if (result != InteractionResult.SUCCESS) {
            if (!((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
                world.m_186460_(pos, (Block)this, tickRate);
                return InteractionResult.SUCCESS;
            }
            if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return result;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (!world.f_46443_ && ((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            this.playSound((Level)world, pos, rand);
            this.performTreeEffect((Level)world, pos, rand);
            world.m_186460_(pos, (Block)this, tickRate);
        }
    }

    protected void performTreeEffect(Level world, BlockPos pos, RandomSource rand) {
        switch (this.type) {
            case TIME: {
                this.performTimeEffect(world, pos, rand);
                break;
            }
            case MINING: {
                this.performMineEffect(world, pos, rand);
                break;
            }
            case SORTING: {
                this.performSortEffect(world, pos, rand);
                break;
            }
            case TRANSFORMATION: {
                this.performTransEffect(world, pos, rand);
            }
        }
    }

    protected void playSound(Level level, BlockPos pos, RandomSource rand) {
        switch (this.type) {
            case TIME: {
                level.m_5594_(null, pos, (SoundEvent)TFSounds.TIME_CORE.get(), SoundSource.BLOCKS, 0.1f, 0.5f);
                break;
            }
            case TRANSFORMATION: {
                level.m_5594_(null, pos, (SoundEvent)TFSounds.TRANSFORMATION_CORE.get(), SoundSource.BLOCKS, 0.1f, rand.m_188501_() * 2.0f);
            }
        }
    }

    protected void performMineEffect(Level level, BlockPos pos, RandomSource rand) {
        BlockPos dPos = WorldUtil.randomOffset((RandomSource)rand, (BlockPos)pos, (int)32);
        int moved = OreMagnetItem.doMagnet((Level)level, (BlockPos)pos, (BlockPos)dPos);
        if (moved > 0) {
            level.m_5594_(null, pos, (SoundEvent)TFSounds.MAGNET_GRAB.get(), SoundSource.BLOCKS, 0.1f, 1.0f);
        }
    }

    protected void performSortEffect(Level level, BlockPos pos, RandomSource rand) {
        HashMap inputHandlers = new HashMap();
        HashMap outputHandlers = new HashMap();
        for (BlockPos blockPos : WorldUtil.getAllAround((BlockPos)pos, (int)16)) {
            BlockEntity blockEntity;
            if (blockPos.equals((Object)pos) || (blockEntity = level.m_7702_(blockPos)) == null) continue;
            blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                if (Math.abs(blockPos.m_123341_() - pos.m_123341_()) <= 2 && Math.abs(blockPos.m_123342_() - pos.m_123342_()) <= 2 && Math.abs(blockPos.m_123343_() - pos.m_123343_()) <= 2) {
                    inputHandlers.put(iItemHandler, Vec3.m_82514_((Vec3i)blockPos, (double)1.9));
                } else {
                    outputHandlers.put(iItemHandler, Vec3.m_82514_((Vec3i)blockPos, (double)1.9));
                }
            });
        }
        level.m_6249_((Entity)null, new AABB(pos).m_82400_(2.0), entity -> entity.m_6084_() && entity.m_6095_().m_204039_(EntityTagGenerator.SORTABLE_ENTITIES)).forEach(entity -> entity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(iItemHandler -> inputHandlers.put(iItemHandler, entity.m_20182_().m_82520_(0.0, (double)entity.m_20206_() + 0.9, 0.0))));
        if (!inputHandlers.isEmpty()) {
            level.m_6249_((Entity)null, new AABB(pos).m_82400_(16.0), entity -> entity.m_6084_() && entity.m_6095_().m_204039_(EntityTagGenerator.SORTABLE_ENTITIES)).forEach(entity -> entity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(iItemHandler -> {
                if (!inputHandlers.containsKey(iItemHandler)) {
                    outputHandlers.put(iItemHandler, entity.m_20182_().m_82520_(0.0, (double)entity.m_20206_() + 0.9, 0.0));
                }
            }));
            if (!outputHandlers.isEmpty()) {
                block1: for (IItemHandler inputIItemHandler : inputHandlers.keySet()) {
                    for (int i = 0; i < inputIItemHandler.getSlots(); ++i) {
                        ItemStack newStack;
                        int firstProperStack;
                        ItemStack inputStack = inputIItemHandler.extractItem(i, 1, true);
                        if (inputStack.m_41619_()) continue;
                        boolean transferred = false;
                        HashMap<Integer, IItemHandler> outputsByCount = new HashMap<Integer, IItemHandler>();
                        for (IItemHandler outputIItemHandler : outputHandlers.keySet()) {
                            int count = 0;
                            for (firstProperStack = 0; firstProperStack < outputIItemHandler.getSlots(); ++firstProperStack) {
                                newStack = outputIItemHandler.getStackInSlot(firstProperStack);
                                if (!newStack.m_150930_(inputStack.m_41720_())) continue;
                                count += newStack.m_41613_();
                            }
                            if (count <= 0) continue;
                            outputsByCount.put(count, outputIItemHandler);
                        }
                        for (IItemHandler outputIItemHandler : outputsByCount.values()) {
                            firstProperStack = -1;
                            for (int j = 0; j < outputIItemHandler.getSlots(); ++j) {
                                ItemStack outputStack = outputIItemHandler.getStackInSlot(j);
                                if (firstProperStack == -1 && outputStack.m_41619_()) {
                                    firstProperStack = j;
                                    continue;
                                }
                                if (!ItemStack.m_150942_((ItemStack)inputStack, (ItemStack)outputStack) || outputStack.m_41613_() >= outputStack.m_41741_() || outputStack.m_41613_() >= outputIItemHandler.getSlotLimit(j)) continue;
                                firstProperStack = j;
                                break;
                            }
                            if (firstProperStack == -1 || (newStack = inputIItemHandler.extractItem(i, 1, false)).m_41619_() || !outputIItemHandler.insertItem(firstProperStack, newStack, true).m_41619_()) continue;
                            outputIItemHandler.insertItem(firstProperStack, newStack, false);
                            transferred = true;
                            Vec3 xyz = (Vec3)outputHandlers.get(outputIItemHandler);
                            Vec3 diff = ((Vec3)inputHandlers.get(inputIItemHandler)).m_82546_(xyz);
                            for (ServerPlayer serverplayer : ((ServerLevel)level).m_6907_()) {
                                if (!(serverplayer.m_20238_(xyz) < 4096.0)) continue;
                                ParticlePacket particlePacket = new ParticlePacket();
                                double x = diff.f_82479_ - 0.25 + rand.m_188500_() * 0.5;
                                double y = diff.f_82480_ - 1.75 + rand.m_188500_() * 0.5;
                                double z = diff.f_82481_ - 0.25 + rand.m_188500_() * 0.5;
                                particlePacket.queueParticle((ParticleOptions)TFParticleType.SORTING_PARTICLE.get(), false, xyz, new Vec3(x, y, z).m_82490_(1.0 / diff.m_82553_()));
                                TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverplayer), (Object)particlePacket);
                            }
                        }
                        if (transferred) continue block1;
                    }
                }
            }
        }
    }

    protected void performTimeEffect(Level world, BlockPos pos, RandomSource rand) {
        int numticks = 24 * tickRate;
        for (int i = 0; i < numticks; ++i) {
            BlockEntityTicker ticker;
            BlockEntity entity;
            BlockPos dPos = WorldUtil.randomOffset((RandomSource)rand, (BlockPos)pos, (int)16);
            BlockState state = world.m_8055_(dPos);
            if (state.m_60823_()) {
                state.m_222972_((ServerLevel)world, dPos, rand);
            }
            if ((entity = world.m_7702_(dPos)) == null || (ticker = state.m_155944_(world, entity.m_58903_())) == null) continue;
            ticker.m_155252_(world, dPos, state, entity);
        }
    }

    protected void performTransEffect(Level level, BlockPos pos, RandomSource rand) {
        ResourceKey target = TFBiomes.ENCHANTED_FOREST;
        Holder.Reference biome = level.m_9598_().m_175515_(Registries.f_256952_).m_246971_(target);
        int range = (Integer)TFConfig.COMMON_CONFIG.MAGIC_TREES.transformationRange.get();
        for (int i = 0; i < 16; ++i) {
            BlockPos dPos = WorldUtil.randomOffset((RandomSource)rand, (BlockPos)pos, (int)range, (int)0, (int)range);
            if (dPos.m_123331_((Vec3i)pos) > 256.0 || level.m_204166_(dPos).m_203565_(target)) continue;
            int minY = QuartPos.m_175400_((int)level.m_141937_());
            int maxY = minY + QuartPos.m_175400_((int)level.m_141928_()) - 1;
            int x = QuartPos.m_175400_((int)dPos.m_123341_());
            int z = QuartPos.m_175400_((int)dPos.m_123343_());
            LevelChunk chunkAt = level.m_6325_(dPos.m_123341_() >> 4, dPos.m_123343_() >> 4);
            for (LevelChunkSection section : chunkAt.m_7103_()) {
                for (int sy = 0; sy < 16; sy += 4) {
                    PalettedContainerRO var21;
                    int y = Mth.m_14045_((int)QuartPos.m_175400_((int)(chunkAt.m_151560_() + sy)), (int)minY, (int)maxY);
                    if (((Holder)section.m_187996_().m_63087_(x & 3, y & 3, z & 3)).m_203565_(target) || !((var21 = section.m_187996_()) instanceof PalettedContainer)) continue;
                    PalettedContainer container = (PalettedContainer)var21;
                    container.m_156470_(x & 3, y & 3, z & 3, (Object)biome);
                }
            }
            if (!(level instanceof ServerLevel)) break;
            ServerLevel server = (ServerLevel)level;
            if (!chunkAt.m_6344_()) {
                chunkAt.m_8092_(true);
            }
            server.m_7726_().f_8325_.m_274524_(List.of(chunkAt));
            break;
        }
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return 15;
    }

    public float getPrimitiveLogs(float volumeIn, List<ItemStack> drops) {
        MagicFamily magicFamily;
        float ret = super.getPrimitiveLogs(volumeIn, drops);
        if (!this.getFamily().getPrimitiveLog().isPresent()) {
            return ret;
        }
        Block primitiveLog = (Block)this.getFamily().getPrimitiveLog().get();
        Family family = this.getFamily();
        if (!(family instanceof MagicFamily) || !(magicFamily = (MagicFamily)family).getPrimitiveCoreLog().isPresent()) {
            return ret;
        }
        Block primitiveCoreLog = magicFamily.getPrimitiveCoreLog().get();
        int addLogs = 0;
        for (ItemStack stack : drops) {
            if (!stack.m_150930_(new ItemStack((ItemLike)primitiveCoreLog).m_41720_())) continue;
            int logCount = stack.m_41613_();
            if (logCount <= 1) break;
            stack.m_41764_(0);
            addLogs = logCount - 1;
            break;
        }
        if (addLogs > 0) {
            drops.add(new ItemStack((ItemLike)primitiveLog, addLogs));
        }
        return ret;
    }

    public static enum coreType {
        TIME,
        TRANSFORMATION,
        SORTING,
        MINING;

    }
}

