/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Either;
import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import dev.corgitaco.enhancedcelestials.api.EnhancedCelestialsRegistry;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import dev.corgitaco.enhancedcelestials.lunarevent.EnhancedCelestialsLunarForecastWorldData;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;

public class SetLunarEventCommand {
    private static final DynamicCommandExceptionType ERROR_LUNAR_EVENT_INVALID = new DynamicCommandExceptionType(obj -> Component.m_237110_((String)"enhancedcelestials.commands.setlunarevent.invalid", (Object[])new Object[]{obj}));

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return Commands.m_82127_((String)"setLunarEvent").then(Commands.m_82129_((String)"lunarEvent", (ArgumentType)ResourceOrTagKeyArgument.m_247494_(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY)).executes(cs -> SetLunarEventCommand.setLunarEvent((CommandSourceStack)cs.getSource(), (ResourceOrTagKeyArgument.Result<LunarEvent>)ResourceOrTagKeyArgument.m_246379_((CommandContext)cs, (String)"lunarEvent", EnhancedCelestialsRegistry.LUNAR_EVENT_KEY, (DynamicCommandExceptionType)ERROR_LUNAR_EVENT_INVALID))));
    }

    public static int setLunarEvent(CommandSourceStack source, ResourceOrTagKeyArgument.Result<LunarEvent> lunarEventResult) {
        ServerLevel world = source.m_81372_();
        Optional<EnhancedCelestialsLunarForecastWorldData> lunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData((Level)world);
        if (lunarForecastWorldData.isEmpty()) {
            source.m_81352_((Component)Component.m_237115_((String)"enhancedcelestials.commands.disabled"));
            return 0;
        }
        EnhancedCelestialsLunarForecastWorldData data = lunarForecastWorldData.orElseThrow();
        if (world.m_46471_() && data.getDimensionSettings().requiresClearSkies()) {
            source.m_81352_((Component)Component.m_237113_((String)"Lunar events can only be started during clear skies!"));
            return 0;
        }
        Either unwrap = lunarEventResult.m_245276_();
        if (unwrap.left().isPresent()) {
            ResourceKey lunarEventResourceKey = (ResourceKey)unwrap.left().orElseThrow();
            Registry lunarEvents = (Registry)world.m_9598_().m_6632_(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY).orElseThrow();
            if (lunarEvents.m_142003_(lunarEventResourceKey) && lunarEvents.m_246971_(lunarEventResourceKey).m_203633_()) {
                data.setLunarEvent((ResourceKey<LunarEvent>)lunarEventResourceKey);
                return 1;
            }
            source.m_81352_((Component)Component.m_237113_((String)"Invalid lunar event \"%s\"!".formatted(lunarEventResourceKey.m_135782_())));
            return 0;
        }
        if (unwrap.right().isPresent()) {
            Optional possibleTag = ((Registry)world.m_9598_().m_6632_(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY).orElseThrow()).m_203431_((TagKey)unwrap.right().orElseThrow());
            if (possibleTag.isPresent()) {
                HolderSet.Named possibleLunarEvents = (HolderSet.Named)possibleTag.orElseThrow();
                Optional randomLunarEvent = possibleLunarEvents.m_213653_(world.f_46441_);
                if (randomLunarEvent.isPresent()) {
                    source.m_81377_().m_18707_(() -> data.setLunarEvent((ResourceKey<LunarEvent>)((ResourceKey)((Holder)randomLunarEvent.orElseThrow()).m_203543_().orElseThrow())));
                    return 1;
                }
                source.m_81352_((Component)Component.m_237113_((String)"Invalid lunar event tag \"%s\"!".formatted(possibleLunarEvents.m_205839_().f_203868_())));
                return 0;
            }
            source.m_81352_((Component)Component.m_237113_((String)"Invalid lunar event tag."));
            return 0;
        }
        source.m_81352_((Component)Component.m_237113_((String)"Could not start Lunar Event..."));
        return 0;
    }
}

