/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.block.behavior.BlockBehaviorRegistry;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.customization.block.component.LayeredComponent;
import snownee.kiwi.customization.block.loader.KBlockComponents;

public record CycleVariantsComponent(IntegerProperty property, boolean rightClickToCycle) implements KBlockComponent,
LayeredComponent
{
    public static final Codec<CycleVariantsComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_144629_.fieldOf("amount").forGetter(CycleVariantsComponent::maxValue), (App)Codec.BOOL.optionalFieldOf("right_click_to_cycle", (Object)true).forGetter(CycleVariantsComponent::rightClickToCycle)).apply((Applicative)instance, CycleVariantsComponent::create));

    public static CycleVariantsComponent create(int amount) {
        return CycleVariantsComponent.create(amount, true);
    }

    public static CycleVariantsComponent create(int amount, boolean rightClickToCycle) {
        return new CycleVariantsComponent(KBlockUtils.internProperty(IntegerProperty.m_61631_((String)"variant", (int)1, (int)amount)), rightClickToCycle);
    }

    @Override
    public KBlockComponent.Type<?> type() {
        return KBlockComponents.CYCLE_VARIANTS.getOrCreate();
    }

    @Override
    public void injectProperties(Block block, StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.property});
    }

    @Override
    public BlockState registerDefaultState(BlockState state) {
        return (BlockState)state.m_61124_((Property)this.property, (Comparable)Integer.valueOf(this.getDefaultLayer()));
    }

    public int minValue() {
        return this.property.f_223000_;
    }

    public int maxValue() {
        return this.property.f_223001_;
    }

    @Override
    public IntegerProperty getLayerProperty() {
        return this.property;
    }

    @Override
    public int getDefaultLayer() {
        return this.minValue();
    }

    @Override
    public void addBehaviors(BlockBehaviorRegistry registry) {
        if (this.rightClickToCycle) {
            registry.addUseHandler((pState, pPlayer, pLevel, pHand, pHit) -> {
                BlockState newState = (BlockState)pState.m_61122_((Property)this.property);
                pLevel.m_7731_(pHit.m_82425_(), newState, 3);
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            });
        }
    }
}

