/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.mapping;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.ErrorFactory;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.array.ArrayLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public abstract class CollectionLoadable<T, C extends Collection<T>>
implements ArrayLoadable<C> {
    protected final Loadable<T> base;
    private final int minSize;

    protected Collection<T> createBuilder(int size) {
        return new ArrayList(size);
    }

    protected abstract C build(Collection<T> var1);

    @Override
    public void checkSize(String key, int size, ErrorFactory error) {
        int minSize = this.minSize;
        if (minSize == -1) {
            minSize = 1;
        }
        if (size < minSize) {
            throw error.create(key + " must have at least " + minSize + " elements");
        }
    }

    @Override
    public boolean allowCompact() {
        return this.minSize < 0;
    }

    @Override
    public int getLength(C array) {
        return array.size();
    }

    @Override
    public C convertCompact(JsonElement element, String key, TypedMap context) {
        return this.build(List.of(this.base.convert(element, key, context)));
    }

    @Override
    public C convertArray(JsonArray array, String key, TypedMap context) {
        Collection<T> builder = this.createBuilder(array.size());
        for (int i = 0; i < array.size(); ++i) {
            builder.add(this.base.convert(array.get(i), key + "[" + i + "]", context));
        }
        return this.build(builder);
    }

    @Override
    public JsonElement serializeFirst(C collection) {
        return this.base.serialize(collection.iterator().next());
    }

    @Override
    public void serializeAll(JsonArray array, C collection) {
        for (Object element : collection) {
            array.add(this.base.serialize(element));
        }
    }

    @Override
    public C decode(FriendlyByteBuf buffer, TypedMap context) {
        int max = buffer.m_130242_();
        Collection<T> builder = this.createBuilder(max);
        for (int i = 0; i < max; ++i) {
            builder.add(this.base.decode(buffer, context));
        }
        return this.build(builder);
    }

    @Override
    public void encode(FriendlyByteBuf buffer, C collection) {
        buffer.m_130130_(collection.size());
        for (Object element : collection) {
            this.base.encode(buffer, element);
        }
    }

    public CollectionLoadable(Loadable<T> base, int minSize) {
        this.base = base;
        this.minSize = minSize;
    }
}

