/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.blocks;

import net.mehvahdjukaar.sleep_tight.common.blocks.IModBed;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class NightBagBlock
extends BedBlock
implements IModBed {
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape SHAPE_HACK = Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)Block.m_49796_((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0));

    public NightBagBlock(BlockBehaviour.Properties properties) {
        super(DyeColor.BLUE, properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.m_61143_((Property)f_49440_) == BedPart.HEAD ? SHAPE_HACK : SHAPE;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.m_142072_(level, state, pos, entity, fallDistance * 2.0f);
    }

    public void m_5548_(BlockGetter level, Entity entity) {
        entity.m_20256_(entity.m_20184_().m_82542_(1.0, 0.0, 1.0));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return null;
    }

    @Override
    public Vec3 getSleepingPosition(BlockState state, BlockPos pos) {
        return Vec3.m_82512_((Vec3i)pos).m_82492_(0.0, 0.25, 0.0);
    }

    @Override
    public boolean canSetSpawn() {
        return false;
    }

    @Override
    public boolean st_canCauseNightmares() {
        return CommonConfigs.NIGHTMARES_HAMMOCK.get();
    }

    @Override
    public long st_getCooldown() {
        return CommonConfigs.NIGHT_BAG_COOLDOWN.get().intValue();
    }

    @Override
    public boolean st_hasPenalties() {
        return CommonConfigs.PENALTIES_NIGHT_BAG.get();
    }

    @Override
    public boolean st_hasRequirements() {
        return CommonConfigs.REQUIREMENT_NIGHT_BAG.get();
    }

    @Override
    public boolean st_canSpawnBedbugs() {
        return false;
    }

    @Override
    public void onLeftBed(BlockState state, BlockPos pos, Player player) {
        Level level = player.m_9236_();
        level.m_7471_(pos, false);
        BlockPos blockPos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_());
        if (level.m_8055_(blockPos).m_60713_((Block)this)) {
            level.m_7471_(blockPos, false);
        }
        InteractionHand hand = player.m_7655_();
        ItemStack stack = new ItemStack((ItemLike)this);
        if (!player.m_150110_().f_35937_) {
            if (player.m_21120_(hand).m_41619_()) {
                player.m_21008_(hand, stack);
            } else if (!player.m_150109_().m_36054_(stack)) {
                player.m_36176_(stack, false);
            }
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        BlockPos blockPos = context.m_8083_();
        BlockPos blockPos2 = blockPos.m_121945_(direction);
        Level level = context.m_43725_();
        return level.m_8055_(blockPos2).m_60629_(context) && level.m_6857_().m_61937_(blockPos2) && this.isSupporting(level, blockPos.m_7495_()) && this.isSupporting(level, blockPos2.m_7495_()) ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_49440_, (Comparable)BedPart.HEAD)).m_61124_((Property)f_54117_, (Comparable)direction.m_122424_()) : null;
    }

    private boolean isSupporting(Level level, BlockPos blockPos) {
        return level.m_8055_(blockPos).m_60783_((BlockGetter)level, blockPos, Direction.UP);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (state.m_61143_((Property)f_49440_) == BedPart.HEAD && !level.f_46443_) {
            BlockPos blockPos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_());
            level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)f_49440_, (Comparable)BedPart.FOOT), 3);
            level.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)level, pos, 3);
            if (CommonConfigs.NIGHT_BAG_BORING.get().booleanValue()) {
                return;
            }
            if (placer instanceof Player) {
                Player player = (Player)placer;
                this.m_6227_(state, level, pos, player, placer.m_7655_(), new BlockHitResult(Vec3.m_82539_((Vec3i)pos), Direction.DOWN, pos, false));
            }
        } else {
            super.m_6402_(level, pos, state, placer, stack);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (direction == Direction.DOWN && !neighborState.m_60783_((BlockGetter)level, neighborPos, Direction.UP)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }
}

