/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.systems.nodemapper.CoderNode;
import com.ferreusveritas.dynamictrees.systems.nodemapper.FindEndsNode;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.ferreusveritas.dynamictrees.worldgen.GenerationContext;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class RootsJoCode
extends JoCode {
    public RootsJoCode(String code) {
        super(code);
    }

    public RootsJoCode(Level level, BlockPos rootPos, Direction facing) {
        super(level, rootPos, facing);
    }

    @Override
    protected void getCodeFromWorld(Level level, BlockPos rootPos, Direction facing) {
        Optional<BranchBlock> branch = TreeHelper.getBranchOpt(level.m_8055_(rootPos.m_7495_()));
        if (branch.isPresent()) {
            CoderNode coder = new CoderNode();
            branch.get().analyse(level.m_8055_(rootPos), (LevelAccessor)level, rootPos, Direction.UP, new MapSignal(coder));
            this.instructions = coder.compile(this);
            this.rotate(facing);
        }
    }

    @Override
    public void generate(GenerationContext context) {
        int rootRadius;
        LevelAccessor level = context.level();
        Species species = context.species();
        int radius = context.radius();
        boolean worldGen = context.safeBounds() != SafeChunkBounds.ANY;
        this.setFacing(context.facing());
        BlockPos.MutableBlockPos rootPos = context.rootPos();
        if (rootPos == BlockPos.f_121853_) {
            return;
        }
        BlockState rootState = level.m_8055_((BlockPos)context.rootPos());
        Block block = rootState.m_60734_();
        if (block instanceof RootyBlock) {
            RootyBlock rooty = (RootyBlock)block;
            rootRadius = rooty.updateRadius(level, rootState, (BlockPos)context.rootPos(), 2, false);
        } else {
            rootRadius = 8;
        }
        this.generateFork(level, species, 0, (BlockPos)rootPos, false);
        BlockPos rootsPos = rootPos.m_7495_();
        BlockState rootsState = level.m_8055_(rootsPos);
        BranchBlock firstBranch = TreeHelper.getBranch(rootsState);
        if (firstBranch == null) {
            return;
        }
        SimpleVoxmap rootsMap = new SimpleVoxmap(radius * 2 + 1, species.getWorldGenLeafMapHeight(), radius * 2 + 1).setMapAndCenter(rootsPos, new BlockPos(radius, species.getWorldGenLeafMapHeight(), radius));
        NodeInspector inflator = species.getNodeInflator(rootsMap, rootRadius);
        FindEndsNode endFinder = new FindEndsNode();
        MapSignal signal = new MapSignal(inflator, endFinder);
        signal.destroyLoopedNodes = this.careful;
        firstBranch.analyse(rootsState, level, rootsPos, Direction.UP, signal);
        if (signal.foundRoot || signal.overflow) {
            this.tryGenerateAgain(context, worldGen, rootsPos, rootsState, endFinder);
            return;
        }
        List<BlockPos> endPoints = endFinder.getEnds();
        species.handleRot(level, endPoints, (BlockPos)rootPos, rootsPos, 0, context.safeBounds());
    }

    @Override
    protected boolean setBlockForGeneration(LevelAccessor level, Species species, BlockPos pos, Direction dir, boolean careful, boolean isLast) {
        if (this.isFreeToSetBlock(level, pos, species) && (!careful || this.isClearOfNearbyBranches(level, pos, dir.m_122424_()))) {
            species.getFamily().getBranchForRootsPlacement(level, species, pos).ifPresent(branch -> branch.setRadius(level, pos, species.getFamily().getPrimaryRootThickness(), null, careful ? 3 : 2));
            return false;
        }
        return true;
    }

    @Override
    protected boolean isFreeToSetBlock(LevelAccessor level, BlockPos pos, Species species) {
        return species.getFamily().isAcceptableSoilForRootSystem(level.m_8055_(pos)) || super.isFreeToSetBlock(level, pos, species);
    }
}

