/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.joml.Vector3f;

public class ModelUtils {
    public static float[] getUVs(AABB box, Direction face) {
        switch (face) {
            default: {
                return new float[]{(float)box.f_82288_, 16.0f - (float)box.f_82290_, (float)box.f_82291_, 16.0f - (float)box.f_82293_};
            }
            case UP: {
                return new float[]{(float)box.f_82288_, (float)box.f_82290_, (float)box.f_82291_, (float)box.f_82293_};
            }
            case NORTH: {
                return new float[]{16.0f - (float)box.f_82291_, (float)box.f_82289_, 16.0f - (float)box.f_82288_, (float)box.f_82292_};
            }
            case SOUTH: {
                return new float[]{(float)box.f_82288_, (float)box.f_82289_, (float)box.f_82291_, (float)box.f_82292_};
            }
            case WEST: {
                return new float[]{(float)box.f_82290_, (float)box.f_82289_, (float)box.f_82293_, (float)box.f_82292_};
            }
            case EAST: 
        }
        return new float[]{16.0f - (float)box.f_82293_, (float)box.f_82289_, 16.0f - (float)box.f_82290_, (float)box.f_82292_};
    }

    public static int getFaceAngle(Direction.Axis axis, Direction face) {
        if (axis == Direction.Axis.Y) {
            return 0;
        }
        if (axis == Direction.Axis.Z) {
            switch (face) {
                case UP: {
                    return 0;
                }
                case WEST: {
                    return 270;
                }
                case DOWN: {
                    return 180;
                }
                case NORTH: {
                    return 270;
                }
            }
            return 90;
        }
        return face == Direction.NORTH ? 270 : 90;
    }

    public static float[] modUV(float[] uvs) {
        uvs[0] = (int)uvs[0] & 0xF;
        uvs[1] = (int)uvs[1] & 0xF;
        uvs[2] = ((int)uvs[2] - 1 & 0xF) + 1;
        uvs[3] = ((int)uvs[3] - 1 & 0xF) + 1;
        return uvs;
    }

    public static Vector3f[] AABBLimits(AABB aabb) {
        return new Vector3f[]{new Vector3f((float)aabb.f_82288_, (float)aabb.f_82289_, (float)aabb.f_82290_), new Vector3f((float)aabb.f_82291_, (float)aabb.f_82292_, (float)aabb.f_82293_)};
    }

    public static BakedQuad makeBakedQuad(BlockElement blockPart, BlockElementFace partFace, TextureAtlasSprite atlasSprite, Direction dir, BlockModelRotation modelRotation, ResourceLocation modelResLoc) {
        return new FaceBakery().m_111600_(blockPart.f_111308_, blockPart.f_111309_, partFace, atlasSprite, dir, (ModelState)modelRotation, blockPart.f_111311_, true, modelResLoc);
    }

    public static IModelBuilder<?> getModelBuilder(IGeometryBakingContext context, TextureAtlasSprite particle) {
        ResourceLocation renderTypeHint = context.getRenderTypeHint();
        RenderTypeGroup renderTypes = renderTypeHint != null ? context.getRenderType(renderTypeHint) : RenderTypeGroup.EMPTY;
        return IModelBuilder.of((boolean)context.useAmbientOcclusion(), (boolean)context.useBlockLight(), (boolean)context.isGui3d(), (ItemTransforms)context.getTransforms(), (ItemOverrides)ItemOverrides.f_111734_, (TextureAtlasSprite)particle, (RenderTypeGroup)renderTypes);
    }

    public static TextureAtlasSprite getTexture(ResourceLocation resLoc) {
        return ModelUtils.getTexture(resLoc, TextureAtlas.f_118259_);
    }

    public static TextureAtlasSprite getTexture(ResourceLocation resLoc, ResourceLocation atlasResLoc) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(atlasResLoc).apply(resLoc);
    }
}

