/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block.rooty;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.data.WaterRootGenerator;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.block.rooty.SoilProperties;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WaterSoilProperties
extends SoilProperties {
    public static final TypedRegistry.EntryType<SoilProperties> TYPE = TypedRegistry.newType(WaterSoilProperties::new);

    public WaterSoilProperties(ResourceLocation registryName) {
        super(null, registryName);
        this.soilStateGenerator.reset(WaterRootGenerator::new);
    }

    @Override
    protected RootyBlock createBlock(BlockBehaviour.Properties blockProperties) {
        return new RootyWaterBlock(this, blockProperties);
    }

    @Override
    public MapColor getDefaultMapColor() {
        return MapColor.f_283864_;
    }

    @Override
    public BlockBehaviour.Properties getDefaultBlockProperties(MapColor mapColor) {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_);
    }

    public static class RootyWaterBlock
    extends RootyBlock
    implements SimpleWaterloggedBlock {
        protected static final AABB WATER_ROOTS_AABB = new AABB(0.1, 0.0, 0.1, 0.9, 1.0, 0.9);
        public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

        public RootyWaterBlock(SoilProperties properties, BlockBehaviour.Properties blockProperties) {
            super(properties, blockProperties);
            this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{WATERLOGGED}));
        }

        @Override
        public int getRadiusForConnection(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
            return 1;
        }

        @Override
        public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
            BlockState upState = level.m_8055_(pos.m_7494_());
            if (TreeHelper.isBranch(upState)) {
                return TreeHelper.getBranch(upState).getFamily().getBranchItem().map(ItemStack::new).orElse(ItemStack.f_41583_);
            }
            return ItemStack.f_41583_;
        }

        @Override
        public float getHardness(BlockState state, BlockGetter level, BlockPos pos) {
            return (float)(0.5 * (Double)DTConfigs.ROOTY_BLOCK_HARDNESS_MULTIPLIER.get());
        }

        @Override
        public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            return Shapes.m_83064_((AABB)WATER_ROOTS_AABB);
        }

        public VoxelShape m_7947_(BlockState state, BlockGetter reader, BlockPos pos) {
            return Shapes.m_83040_();
        }

        public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
            return false;
        }

        public FluidState m_5888_(BlockState state) {
            return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
        }

        public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
            if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
            }
            return super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
        }

        @Override
        public BlockState getDecayBlockState(BlockState state, BlockGetter level, BlockPos pos) {
            if (state.m_61138_((Property)WATERLOGGED) && !((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                return Blocks.f_50016_.m_49966_();
            }
            return super.getDecayBlockState(state, level, pos);
        }

        @Override
        public boolean getColorFromBark() {
            return true;
        }

        @Override
        public boolean fallWithTree(BlockState state, Level level, BlockPos pos) {
            level.m_46597_(pos, this.getDecayBlockState(state, (BlockGetter)level, pos));
            return true;
        }
    }
}

