/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.registry;

import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTItemModelProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTLangProvider;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public abstract class RegistryEntry<T extends RegistryEntry<T>> {
    private ResourceLocation registryName;
    private boolean valid = true;
    private boolean generateData;

    protected RegistryEntry() {
    }

    protected RegistryEntry(ResourceLocation registryName) {
        this.registryName = registryName;
    }

    protected T nullEntry() {
        this.valid = false;
        return (T)this;
    }

    public boolean isValid() {
        return this.valid;
    }

    public final boolean ifValid(Consumer<T> consumer) {
        if (this.isValid()) {
            consumer.accept(this);
            return true;
        }
        return false;
    }

    public final boolean ifValidElse(Consumer<T> consumer, Runnable runnable) {
        if (this.isValid()) {
            consumer.accept(this);
            return true;
        }
        runnable.run();
        return false;
    }

    public final T elseIfInvalid(T otherValue) {
        return (T)(this.isValid() ? this : otherValue);
    }

    public final boolean ifInvalid(Runnable runnable) {
        if (!this.isValid()) {
            runnable.run();
            return true;
        }
        return false;
    }

    public boolean shouldGenerateData() {
        return this.generateData;
    }

    public void setGenerateData(boolean generateData) {
        this.generateData = generateData;
    }

    public void generateStateData(DTBlockStateProvider provider) {
    }

    public void generateItemModelData(DTItemModelProvider provider) {
    }

    public void generateLangData(DTLangProvider provider) {
    }

    public final ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public Component getTextComponent() {
        return this.formatComponent((Component)Component.m_237113_((String)this.getRegistryName().toString()), ChatFormatting.AQUA);
    }

    protected Component formatComponent(Component component, ChatFormatting colour) {
        return component.m_6881_().m_130938_(style -> style.m_131140_(colour).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237110_((String)"chat.registry_name", (Object[])new Object[]{this.getRegistryName()}))).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, this.getRegistryName().toString())));
    }

    public final T setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
        return (T)this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{registryName=" + String.valueOf(this.getRegistryName()) + "}";
    }

    public String toLoadDataString() {
        return this.toString();
    }

    public String toReloadDataString() {
        return this.toString();
    }

    @SafeVarargs
    public final String getString(Pair<String, Object> ... propertyPairs) {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName() + "{registryName=" + String.valueOf(this.getRegistryName()) + ", ");
        for (int i = 0; i < propertyPairs.length; ++i) {
            Pair<String, Object> currentProperty = propertyPairs[i];
            stringBuilder.append((String)currentProperty.getKey()).append("=").append(currentProperty.getValue()).append(i != propertyPairs.length - 1 ? ", " : "}");
        }
        return stringBuilder.toString();
    }
}

