/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.items;

import forestry.api.ForestryTags;
import forestry.api.mail.EnumPostage;
import forestry.core.items.ItemOverlay;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.chat.TextColor;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;

public enum EnumStampDefinition implements ItemOverlay.IOverlayInfo
{
    P_1("1n", EnumPostage.P_1, ForestryTags.Items.GEMS_APATITE, TextColor.m_131266_((int)4885671), TextColor.m_131266_((int)0xFFFFFF)),
    P_2("2n", EnumPostage.P_2, Items.f_151052_, TextColor.m_131266_((int)15255572), TextColor.m_131266_((int)0xFFFFFF)),
    P_5("5n", EnumPostage.P_5, ForestryTags.Items.INGOTS_TIN, TextColor.m_131266_((int)10225415), TextColor.m_131266_((int)0xFFFFFF)),
    P_10("10n", EnumPostage.P_10, (TagKey<Item>)Tags.Items.INGOTS_GOLD, TextColor.m_131266_((int)8114616), TextColor.m_131266_((int)0xFFFFFF)),
    P_20("20n", EnumPostage.P_20, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, TextColor.m_131266_((int)16748593), TextColor.m_131266_((int)0xFFF7DD)),
    P_50("50n", EnumPostage.P_50, (TagKey<Item>)Tags.Items.GEMS_EMERALD, TextColor.m_131266_((int)6566359), TextColor.m_131266_((int)0xFFF7DD)),
    P_100("100n", EnumPostage.P_100, Items.f_42686_, TextColor.m_131266_((int)14102970), TextColor.m_131266_((int)0xFFF7DD));

    public static final EnumStampDefinition[] VALUES;
    private static final Map<EnumPostage, EnumStampDefinition> POSTAGE_MAP;
    private final String name;
    private final int primaryColor;
    private final int secondaryColor;
    private final Supplier<Ingredient> craftingIngredient;
    private final EnumPostage postage;

    private EnumStampDefinition(String name, EnumPostage postage, TagKey<Item> crafting, TextColor primaryColor, TextColor secondaryColor) {
        this(name, postage, () -> Ingredient.m_204132_((TagKey)crafting), primaryColor, secondaryColor);
    }

    private EnumStampDefinition(String name, EnumPostage postage, Item crafting, TextColor primaryColor, TextColor secondaryColor) {
        this(name, postage, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{crafting}), primaryColor, secondaryColor);
    }

    private EnumStampDefinition(String name, EnumPostage postage, Supplier<Ingredient> crafting, TextColor primaryColor, TextColor secondaryColor) {
        this.name = name;
        this.primaryColor = primaryColor.m_131265_();
        this.secondaryColor = secondaryColor.m_131265_();
        this.craftingIngredient = crafting;
        this.postage = postage;
    }

    public EnumPostage getPostage() {
        return this.postage;
    }

    public Ingredient getCraftingIngredient() {
        return this.craftingIngredient.get();
    }

    public String m_7912_() {
        return this.name;
    }

    @Override
    public int getPrimaryColor() {
        return this.primaryColor;
    }

    @Override
    public int getSecondaryColor() {
        return this.secondaryColor;
    }

    public static EnumStampDefinition getFromPostage(EnumPostage postage) {
        return POSTAGE_MAP.get((Object)postage);
    }

    static {
        VALUES = EnumStampDefinition.values();
        POSTAGE_MAP = new EnumMap<EnumPostage, EnumStampDefinition>(EnumPostage.class);
        for (EnumStampDefinition stampDefinition : VALUES) {
            POSTAGE_MAP.put(stampDefinition.getPostage(), stampDefinition);
        }
    }
}

