/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.ForestryConstants;
import forestry.core.config.ForestryConfig;
import forestry.mail.carriers.players.POBoxInfo;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ToastMailboxInfo
implements Toast {
    private static final long DISPLAY_TIME = 5000L;
    private static final long ICON_TIME = 500L;
    private static final ResourceLocation BACKGROUND_SPRITE = ForestryConstants.forestry("textures/gui/mailalert.png");
    private final Component title = Component.m_237115_((String)"for.gui.mail.toast.title");
    private POBoxInfo poBox;

    public ToastMailboxInfo(POBoxInfo info) {
        this.poBox = info;
    }

    public Toast.Visibility m_7172_(GuiGraphics graphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        if (!((Boolean)ForestryConfig.CLIENT.mailAlertsEnabled.get()).booleanValue()) {
            return Toast.Visibility.HIDE;
        }
        graphics.m_280218_(BACKGROUND_SPRITE, 0, 0, 0, 0, this.m_7828_(), this.m_94899_());
        ArrayList<Icons> icons = new ArrayList<Icons>(2);
        if (!this.poBox.hasMail()) {
            icons.add(Icons.PLAYER_LETTER);
        } else {
            if (this.poBox.playerLetters() > 0) {
                icons.add(Icons.PLAYER_LETTER);
            }
            if (this.poBox.tradeLetters() > 0) {
                icons.add(Icons.TRADE_LETTER);
            }
        }
        ((Icons)((Object)icons.get((int)(timeSinceLastVisible / 500L % (long)icons.size())))).render(graphics, 6, 8);
        Font font = Minecraft.m_91087_().f_91062_;
        graphics.m_280614_(font, this.title, 36, 7, 0xFFFFFF, false);
        graphics.m_280614_(font, (Component)Component.m_237110_((String)"for.gui.mail.toast.message", (Object[])new Object[]{this.poBox.playerLetters() + this.poBox.tradeLetters()}), 36, 18, 0xFFFFFF, false);
        return timeSinceLastVisible >= 5000L || !this.poBox.hasMail() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    public static void addOrUpdate(ToastComponent toastGui, POBoxInfo poBox, boolean modifiedThroughPlayer) {
        ToastMailboxInfo toast = (ToastMailboxInfo)toastGui.m_94926_(ToastMailboxInfo.class, f_94894_);
        if (toast == null && !modifiedThroughPlayer) {
            toastGui.m_94922_((Toast)new ToastMailboxInfo(poBox));
        } else {
            toast.poBox = poBox;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Icons {
        PLAYER_LETTER(0, 0),
        TRADE_LETTER(0, 1);

        private final int x;
        private final int y;

        private Icons(int pX, int pY) {
            this.x = pX;
            this.y = pY;
        }

        public void render(GuiGraphics graphics, int pX, int pY) {
            RenderSystem.enableBlend();
            graphics.m_280218_(BACKGROUND_SPRITE, pX, pY, 176 + this.x * 26, this.y * 15, 26, 15);
            RenderSystem.enableBlend();
        }
    }
}

